/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.developer.loadtesting.models.FunctionFlexConsumptionTargetResourceConfigurations;
import com.azure.developer.loadtesting.models.ResourceKind;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class TargetResourceConfigurations
implements JsonSerializable<TargetResourceConfigurations> {
    private ResourceKind kind = ResourceKind.fromString("TargetResourceConfigurations");
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public ResourceKind getKind() {
        return this.kind;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind.toString());
        return jsonWriter.writeEndObject();
    }

    public static TargetResourceConfigurations fromJson(JsonReader jsonReader) throws IOException {
        return (TargetResourceConfigurations)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                TargetResourceConfigurations targetResourceConfigurations;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("FunctionsFlexConsumption".equals(discriminatorValue)) {
                    targetResourceConfigurations = FunctionFlexConsumptionTargetResourceConfigurations.fromJson(readerToUse.reset());
                    return targetResourceConfigurations;
                }
                targetResourceConfigurations = TargetResourceConfigurations.fromJsonKnownDiscriminator(readerToUse.reset());
                return targetResourceConfigurations;
            }
        });
    }

    static TargetResourceConfigurations fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (TargetResourceConfigurations)jsonReader.readObject(reader -> {
            TargetResourceConfigurations deserializedTargetResourceConfigurations = new TargetResourceConfigurations();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    deserializedTargetResourceConfigurations.kind = ResourceKind.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTargetResourceConfigurations;
        });
    }

    static {
        JsonMergePatchHelper.setTargetResourceConfigurationsAccessor(new JsonMergePatchHelper.TargetResourceConfigurationsAccessor(){

            @Override
            public TargetResourceConfigurations prepareModelForJsonMergePatch(TargetResourceConfigurations model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(TargetResourceConfigurations model) {
                return model.jsonMergePatch;
            }
        });
    }
}

