/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class RegionalConfiguration
implements JsonSerializable<RegionalConfiguration> {
    private int engineInstances;
    private String region;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public int getEngineInstances() {
        return this.engineInstances;
    }

    public RegionalConfiguration setEngineInstances(int engineInstances) {
        this.engineInstances = engineInstances;
        this.updatedProperties.add("engineInstances");
        return this;
    }

    public String getRegion() {
        return this.region;
    }

    public RegionalConfiguration setRegion(String region) {
        this.region = region;
        this.updatedProperties.add("region");
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("engineInstances", this.engineInstances);
        jsonWriter.writeStringField("region", this.region);
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("engineInstances")) {
            jsonWriter.writeIntField("engineInstances", this.engineInstances);
        }
        if (this.updatedProperties.contains("region")) {
            if (this.region == null) {
                jsonWriter.writeNullField("region");
            } else {
                jsonWriter.writeStringField("region", this.region);
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static RegionalConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (RegionalConfiguration)jsonReader.readObject(reader -> {
            RegionalConfiguration deserializedRegionalConfiguration = new RegionalConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("engineInstances".equals(fieldName)) {
                    deserializedRegionalConfiguration.engineInstances = reader.getInt();
                    continue;
                }
                if ("region".equals(fieldName)) {
                    deserializedRegionalConfiguration.region = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRegionalConfiguration;
        });
    }

    static {
        JsonMergePatchHelper.setRegionalConfigurationAccessor(new JsonMergePatchHelper.RegionalConfigurationAccessor(){

            @Override
            public RegionalConfiguration prepareModelForJsonMergePatch(RegionalConfiguration model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(RegionalConfiguration model) {
                return model.jsonMergePatch;
            }
        });
    }
}

