/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.developer.loadtesting.models.PassFailAction;
import com.azure.developer.loadtesting.models.PassFailResult;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class PassFailServerMetric
implements JsonSerializable<PassFailServerMetric> {
    private String resourceId;
    private String metricNamespace;
    private String metricName;
    private String aggregation;
    private String condition;
    private double value;
    private PassFailAction action;
    private Double actualValue;
    private PassFailResult result;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public PassFailServerMetric setResourceId(String resourceId) {
        this.resourceId = resourceId;
        this.updatedProperties.add("resourceId");
        return this;
    }

    public String getMetricNamespace() {
        return this.metricNamespace;
    }

    public PassFailServerMetric setMetricNamespace(String metricNamespace) {
        this.metricNamespace = metricNamespace;
        this.updatedProperties.add("metricNamespace");
        return this;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public PassFailServerMetric setMetricName(String metricName) {
        this.metricName = metricName;
        this.updatedProperties.add("metricName");
        return this;
    }

    public String getAggregation() {
        return this.aggregation;
    }

    public PassFailServerMetric setAggregation(String aggregation) {
        this.aggregation = aggregation;
        this.updatedProperties.add("aggregation");
        return this;
    }

    public String getCondition() {
        return this.condition;
    }

    public PassFailServerMetric setCondition(String condition) {
        this.condition = condition;
        this.updatedProperties.add("condition");
        return this;
    }

    public double getValue() {
        return this.value;
    }

    public PassFailServerMetric setValue(double value) {
        this.value = value;
        this.updatedProperties.add("value");
        return this;
    }

    public PassFailAction getAction() {
        return this.action;
    }

    public Double getActualValue() {
        return this.actualValue;
    }

    public PassFailResult getResult() {
        return this.result;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeStringField("metricNamespace", this.metricNamespace);
        jsonWriter.writeStringField("metricName", this.metricName);
        jsonWriter.writeStringField("aggregation", this.aggregation);
        jsonWriter.writeStringField("condition", this.condition);
        jsonWriter.writeDoubleField("value", this.value);
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("resourceId")) {
            if (this.resourceId == null) {
                jsonWriter.writeNullField("resourceId");
            } else {
                jsonWriter.writeStringField("resourceId", this.resourceId);
            }
        }
        if (this.updatedProperties.contains("metricNamespace")) {
            if (this.metricNamespace == null) {
                jsonWriter.writeNullField("metricNamespace");
            } else {
                jsonWriter.writeStringField("metricNamespace", this.metricNamespace);
            }
        }
        if (this.updatedProperties.contains("metricName")) {
            if (this.metricName == null) {
                jsonWriter.writeNullField("metricName");
            } else {
                jsonWriter.writeStringField("metricName", this.metricName);
            }
        }
        if (this.updatedProperties.contains("aggregation")) {
            if (this.aggregation == null) {
                jsonWriter.writeNullField("aggregation");
            } else {
                jsonWriter.writeStringField("aggregation", this.aggregation);
            }
        }
        if (this.updatedProperties.contains("condition")) {
            if (this.condition == null) {
                jsonWriter.writeNullField("condition");
            } else {
                jsonWriter.writeStringField("condition", this.condition);
            }
        }
        if (this.updatedProperties.contains("value")) {
            jsonWriter.writeDoubleField("value", this.value);
        }
        if (this.updatedProperties.contains("action")) {
            if (this.action == null) {
                jsonWriter.writeNullField("action");
            } else {
                jsonWriter.writeStringField("action", this.action.toString());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static PassFailServerMetric fromJson(JsonReader jsonReader) throws IOException {
        return (PassFailServerMetric)jsonReader.readObject(reader -> {
            PassFailServerMetric deserializedPassFailServerMetric = new PassFailServerMetric();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resourceId".equals(fieldName)) {
                    deserializedPassFailServerMetric.resourceId = reader.getString();
                    continue;
                }
                if ("metricNamespace".equals(fieldName)) {
                    deserializedPassFailServerMetric.metricNamespace = reader.getString();
                    continue;
                }
                if ("metricName".equals(fieldName)) {
                    deserializedPassFailServerMetric.metricName = reader.getString();
                    continue;
                }
                if ("aggregation".equals(fieldName)) {
                    deserializedPassFailServerMetric.aggregation = reader.getString();
                    continue;
                }
                if ("condition".equals(fieldName)) {
                    deserializedPassFailServerMetric.condition = reader.getString();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedPassFailServerMetric.value = reader.getDouble();
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedPassFailServerMetric.action = PassFailAction.fromString(reader.getString());
                    continue;
                }
                if ("actualValue".equals(fieldName)) {
                    deserializedPassFailServerMetric.actualValue = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("result".equals(fieldName)) {
                    deserializedPassFailServerMetric.result = PassFailResult.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPassFailServerMetric;
        });
    }

    public PassFailServerMetric setAction(PassFailAction action) {
        this.action = action;
        this.updatedProperties.add("action");
        return this;
    }

    static {
        JsonMergePatchHelper.setPassFailServerMetricAccessor(new JsonMergePatchHelper.PassFailServerMetricAccessor(){

            @Override
            public PassFailServerMetric prepareModelForJsonMergePatch(PassFailServerMetric model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(PassFailServerMetric model) {
                return model.jsonMergePatch;
            }
        });
    }
}

