/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ArtifactsContainerInfo
implements JsonSerializable<ArtifactsContainerInfo> {
    private String url;
    private OffsetDateTime expiresOn;

    private ArtifactsContainerInfo() {
    }

    public String getUrl() {
        return this.url;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("expireDateTime", this.expiresOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiresOn));
        return jsonWriter.writeEndObject();
    }

    public static ArtifactsContainerInfo fromJson(JsonReader jsonReader) throws IOException {
        return (ArtifactsContainerInfo)jsonReader.readObject(reader -> {
            ArtifactsContainerInfo deserializedArtifactsContainerInfo = new ArtifactsContainerInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedArtifactsContainerInfo.url = reader.getString();
                    continue;
                }
                if ("expireDateTime".equals(fieldName)) {
                    deserializedArtifactsContainerInfo.expiresOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedArtifactsContainerInfo;
        });
    }

    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }
}

