/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter.models;

import com.azure.developer.devcenter.models.DevBoxHardwareProfile;
import com.azure.developer.devcenter.models.DevBoxImageReference;
import com.azure.developer.devcenter.models.DevBoxOsType;
import com.azure.developer.devcenter.models.DevBoxStorageProfile;
import com.azure.developer.devcenter.models.HibernateSupport;
import com.azure.developer.devcenter.models.LocalAdministratorStatus;
import com.azure.developer.devcenter.models.PoolHealthStatus;
import com.azure.developer.devcenter.models.StopOnDisconnectConfiguration;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DevBoxPool
implements JsonSerializable<DevBoxPool> {
    private String name;
    private final String location;
    private DevBoxOsType osType;
    private DevBoxHardwareProfile hardwareProfile;
    private HibernateSupport hibernateSupport;
    private DevBoxStorageProfile storageProfile;
    private DevBoxImageReference imageReference;
    private LocalAdministratorStatus localAdministratorStatus;
    private StopOnDisconnectConfiguration stopOnDisconnect;
    private final PoolHealthStatus healthStatus;

    private DevBoxPool(String location, PoolHealthStatus healthStatus) {
        this.location = location;
        this.healthStatus = healthStatus;
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public DevBoxOsType getOsType() {
        return this.osType;
    }

    public DevBoxHardwareProfile getHardwareProfile() {
        return this.hardwareProfile;
    }

    public HibernateSupport getHibernateSupport() {
        return this.hibernateSupport;
    }

    public DevBoxStorageProfile getStorageProfile() {
        return this.storageProfile;
    }

    public DevBoxImageReference getImageReference() {
        return this.imageReference;
    }

    public LocalAdministratorStatus getLocalAdministratorStatus() {
        return this.localAdministratorStatus;
    }

    public StopOnDisconnectConfiguration getStopOnDisconnect() {
        return this.stopOnDisconnect;
    }

    public PoolHealthStatus getHealthStatus() {
        return this.healthStatus;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeStringField("healthStatus", this.healthStatus == null ? null : this.healthStatus.toString());
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeJsonField("hardwareProfile", (JsonSerializable)this.hardwareProfile);
        jsonWriter.writeStringField("hibernateSupport", this.hibernateSupport == null ? null : this.hibernateSupport.toString());
        jsonWriter.writeJsonField("storageProfile", (JsonSerializable)this.storageProfile);
        jsonWriter.writeJsonField("imageReference", (JsonSerializable)this.imageReference);
        jsonWriter.writeStringField("localAdministrator", this.localAdministratorStatus == null ? null : this.localAdministratorStatus.toString());
        jsonWriter.writeJsonField("stopOnDisconnect", (JsonSerializable)this.stopOnDisconnect);
        return jsonWriter.writeEndObject();
    }

    public static DevBoxPool fromJson(JsonReader jsonReader) throws IOException {
        return (DevBoxPool)jsonReader.readObject(reader -> {
            String name = null;
            String location = null;
            PoolHealthStatus healthStatus = null;
            DevBoxOsType osType = null;
            DevBoxHardwareProfile hardwareProfile = null;
            HibernateSupport hibernateSupport = null;
            DevBoxStorageProfile storageProfile = null;
            DevBoxImageReference imageReference = null;
            LocalAdministratorStatus localAdministratorStatus = null;
            StopOnDisconnectConfiguration stopOnDisconnect = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    location = reader.getString();
                    continue;
                }
                if ("healthStatus".equals(fieldName)) {
                    healthStatus = PoolHealthStatus.fromString(reader.getString());
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    osType = DevBoxOsType.fromString(reader.getString());
                    continue;
                }
                if ("hardwareProfile".equals(fieldName)) {
                    hardwareProfile = DevBoxHardwareProfile.fromJson(reader);
                    continue;
                }
                if ("hibernateSupport".equals(fieldName)) {
                    hibernateSupport = HibernateSupport.fromString(reader.getString());
                    continue;
                }
                if ("storageProfile".equals(fieldName)) {
                    storageProfile = DevBoxStorageProfile.fromJson(reader);
                    continue;
                }
                if ("imageReference".equals(fieldName)) {
                    imageReference = DevBoxImageReference.fromJson(reader);
                    continue;
                }
                if ("localAdministrator".equals(fieldName)) {
                    localAdministratorStatus = LocalAdministratorStatus.fromString(reader.getString());
                    continue;
                }
                if ("stopOnDisconnect".equals(fieldName)) {
                    stopOnDisconnect = StopOnDisconnectConfiguration.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            DevBoxPool deserializedDevBoxPool = new DevBoxPool(location, healthStatus);
            deserializedDevBoxPool.name = name;
            deserializedDevBoxPool.osType = osType;
            deserializedDevBoxPool.hardwareProfile = hardwareProfile;
            deserializedDevBoxPool.hibernateSupport = hibernateSupport;
            deserializedDevBoxPool.storageProfile = storageProfile;
            deserializedDevBoxPool.imageReference = imageReference;
            deserializedDevBoxPool.localAdministratorStatus = localAdministratorStatus;
            deserializedDevBoxPool.stopOnDisconnect = stopOnDisconnect;
            return deserializedDevBoxPool;
        });
    }
}

