/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnValueWireType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.data.appconfiguration.implementation.ConfigurationSettingPage;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import reactor.core.publisher.Mono;

@Host(value="{url}")
@ServiceInterface(name="AppConfig")
public interface ConfigurationService {
    @Get(value="kv/{key}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    public Mono<Response<ConfigurationSetting>> getKeyValue(@HostParam(value="url") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$select") String var5, @HeaderParam(value="Accept-Datetime") String var6, @HeaderParam(value="If-Match") String var7, @HeaderParam(value="If-None-Match") String var8, Context var9);

    @Put(value="kv/{key}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    public Mono<Response<ConfigurationSetting>> setKey(@HostParam(value="url") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") ConfigurationSetting var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, Context var8);

    @Delete(value="kv/{key}")
    @ExpectedResponses(value={200, 204})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    public Mono<Response<ConfigurationSetting>> delete(@HostParam(value="url") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="If-None-Match") String var6, Context var7);

    @Put(value="locks/{key}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    public Mono<Response<ConfigurationSetting>> lockKeyValue(@HostParam(value="url") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="If-None-Match") String var6, Context var7);

    @Delete(value="locks/{key}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    public Mono<Response<ConfigurationSetting>> unlockKeyValue(@HostParam(value="url") String var1, @PathParam(value="key") String var2, @QueryParam(value="label") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="If-None-Match") String var6, Context var7);

    @Get(value="kv")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=ConfigurationSettingPage.class)
    public Mono<PagedResponse<ConfigurationSetting>> listKeyValues(@HostParam(value="url") String var1, @QueryParam(value="key") String var2, @QueryParam(value="label") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$select") String var5, @HeaderParam(value="Accept-Datetime") String var6, Context var7);

    @Get(value="{nextUrl}")
    @ExpectedResponses(value={200})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=ConfigurationSettingPage.class)
    public Mono<PagedResponse<ConfigurationSetting>> listKeyValues(@HostParam(value="url") String var1, @PathParam(value="nextUrl", encoded=true) String var2, Context var3);

    @Get(value="revisions")
    @ExpectedResponses(value={200, 206})
    @UnexpectedResponseExceptionType(value=HttpResponseException.class)
    @ReturnValueWireType(value=ConfigurationSettingPage.class)
    public Mono<PagedResponse<ConfigurationSetting>> listKeyValueRevisions(@HostParam(value="url") String var1, @QueryParam(value="key") String var2, @QueryParam(value="label") String var3, @QueryParam(value="api-version") String var4, @QueryParam(value="$select") String var5, @HeaderParam(value="Accept-Datetime") String var6, @HeaderParam(value="Range") String var7, Context var8);
}

