/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.analytics.synapse.artifacts.models.ZendeskAuthenticationType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ZendeskLinkedService
extends LinkedService {
    private String type = "Zendesk";
    private ZendeskAuthenticationType authenticationType;
    private Object url;
    private Object userName;
    private SecretBase password;
    private SecretBase apiToken;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public ZendeskAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public ZendeskLinkedService setAuthenticationType(ZendeskAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getUrl() {
        return this.url;
    }

    public ZendeskLinkedService setUrl(Object url) {
        this.url = url;
        return this;
    }

    public Object getUserName() {
        return this.userName;
    }

    public ZendeskLinkedService setUserName(Object userName) {
        this.userName = userName;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public ZendeskLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public SecretBase getApiToken() {
        return this.apiToken;
    }

    public ZendeskLinkedService setApiToken(SecretBase apiToken) {
        this.apiToken = apiToken;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public ZendeskLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public ZendeskLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public ZendeskLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public ZendeskLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public ZendeskLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public ZendeskLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.authenticationType != null || this.url != null || this.userName != null || this.password != null || this.apiToken != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            jsonWriter.writeUntypedField("url", this.url);
            if (this.userName != null) {
                jsonWriter.writeUntypedField("userName", this.userName);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            jsonWriter.writeJsonField("apiToken", (JsonSerializable)this.apiToken);
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ZendeskLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (ZendeskLinkedService)jsonReader.readObject(reader -> {
            ZendeskLinkedService deserializedZendeskLinkedService = new ZendeskLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedZendeskLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedZendeskLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedZendeskLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedZendeskLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedZendeskLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedZendeskLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("authenticationType".equals(fieldName)) {
                            deserializedZendeskLinkedService.authenticationType = ZendeskAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("url".equals(fieldName)) {
                            deserializedZendeskLinkedService.url = reader.readUntyped();
                            continue;
                        }
                        if ("userName".equals(fieldName)) {
                            deserializedZendeskLinkedService.userName = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedZendeskLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("apiToken".equals(fieldName)) {
                            deserializedZendeskLinkedService.apiToken = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedZendeskLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedZendeskLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedZendeskLinkedService;
        });
    }
}

