/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.GitHubClientSecret;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public final class WorkspaceRepositoryConfiguration
implements JsonSerializable<WorkspaceRepositoryConfiguration> {
    private String type;
    private String hostName;
    private String accountName;
    private String projectName;
    private String repositoryName;
    private String collaborationBranch;
    private String rootFolder;
    private String lastCommitId;
    private UUID tenantId;
    private String clientId;
    private GitHubClientSecret clientSecret;

    public String getType() {
        return this.type;
    }

    public WorkspaceRepositoryConfiguration setType(String type) {
        this.type = type;
        return this;
    }

    public String getHostName() {
        return this.hostName;
    }

    public WorkspaceRepositoryConfiguration setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public WorkspaceRepositoryConfiguration setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public WorkspaceRepositoryConfiguration setProjectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public WorkspaceRepositoryConfiguration setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
        return this;
    }

    public String getCollaborationBranch() {
        return this.collaborationBranch;
    }

    public WorkspaceRepositoryConfiguration setCollaborationBranch(String collaborationBranch) {
        this.collaborationBranch = collaborationBranch;
        return this;
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public WorkspaceRepositoryConfiguration setRootFolder(String rootFolder) {
        this.rootFolder = rootFolder;
        return this;
    }

    public String getLastCommitId() {
        return this.lastCommitId;
    }

    public WorkspaceRepositoryConfiguration setLastCommitId(String lastCommitId) {
        this.lastCommitId = lastCommitId;
        return this;
    }

    public UUID getTenantId() {
        return this.tenantId;
    }

    public WorkspaceRepositoryConfiguration setTenantId(UUID tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public WorkspaceRepositoryConfiguration setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public GitHubClientSecret getClientSecret() {
        return this.clientSecret;
    }

    public WorkspaceRepositoryConfiguration setClientSecret(GitHubClientSecret clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeStringField("hostName", this.hostName);
        jsonWriter.writeStringField("accountName", this.accountName);
        jsonWriter.writeStringField("projectName", this.projectName);
        jsonWriter.writeStringField("repositoryName", this.repositoryName);
        jsonWriter.writeStringField("collaborationBranch", this.collaborationBranch);
        jsonWriter.writeStringField("rootFolder", this.rootFolder);
        jsonWriter.writeStringField("lastCommitId", this.lastCommitId);
        jsonWriter.writeStringField("tenantId", Objects.toString(this.tenantId, null));
        jsonWriter.writeStringField("clientId", this.clientId);
        jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
        return jsonWriter.writeEndObject();
    }

    public static WorkspaceRepositoryConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (WorkspaceRepositoryConfiguration)jsonReader.readObject(reader -> {
            WorkspaceRepositoryConfiguration deserializedWorkspaceRepositoryConfiguration = new WorkspaceRepositoryConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedWorkspaceRepositoryConfiguration.type = reader.getString();
                    continue;
                }
                if ("hostName".equals(fieldName)) {
                    deserializedWorkspaceRepositoryConfiguration.hostName = reader.getString();
                    continue;
                }
                if ("accountName".equals(fieldName)) {
                    deserializedWorkspaceRepositoryConfiguration.accountName = reader.getString();
                    continue;
                }
                if ("projectName".equals(fieldName)) {
                    deserializedWorkspaceRepositoryConfiguration.projectName = reader.getString();
                    continue;
                }
                if ("repositoryName".equals(fieldName)) {
                    deserializedWorkspaceRepositoryConfiguration.repositoryName = reader.getString();
                    continue;
                }
                if ("collaborationBranch".equals(fieldName)) {
                    deserializedWorkspaceRepositoryConfiguration.collaborationBranch = reader.getString();
                    continue;
                }
                if ("rootFolder".equals(fieldName)) {
                    deserializedWorkspaceRepositoryConfiguration.rootFolder = reader.getString();
                    continue;
                }
                if ("lastCommitId".equals(fieldName)) {
                    deserializedWorkspaceRepositoryConfiguration.lastCommitId = reader.getString();
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedWorkspaceRepositoryConfiguration.tenantId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("clientId".equals(fieldName)) {
                    deserializedWorkspaceRepositoryConfiguration.clientId = reader.getString();
                    continue;
                }
                if ("clientSecret".equals(fieldName)) {
                    deserializedWorkspaceRepositoryConfiguration.clientSecret = GitHubClientSecret.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkspaceRepositoryConfiguration;
        });
    }
}

