/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.DataLakeStorageAccountDetails;
import com.azure.analytics.synapse.artifacts.models.EncryptionDetails;
import com.azure.analytics.synapse.artifacts.models.ManagedIdentity;
import com.azure.analytics.synapse.artifacts.models.ManagedVirtualNetworkSettings;
import com.azure.analytics.synapse.artifacts.models.PrivateEndpointConnection;
import com.azure.analytics.synapse.artifacts.models.PurviewConfiguration;
import com.azure.analytics.synapse.artifacts.models.TrackedResource;
import com.azure.analytics.synapse.artifacts.models.VirtualNetworkProfile;
import com.azure.analytics.synapse.artifacts.models.WorkspaceRepositoryConfiguration;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Workspace
extends TrackedResource {
    private ManagedIdentity identity;
    private DataLakeStorageAccountDetails defaultDataLakeStorage;
    private String sqlAdministratorLoginPassword;
    private String managedResourceGroupName;
    private String provisioningState;
    private String sqlAdministratorLogin;
    private VirtualNetworkProfile virtualNetworkProfile;
    private Map<String, String> connectivityEndpoints;
    private String managedVirtualNetwork;
    private List<PrivateEndpointConnection> privateEndpointConnections;
    private EncryptionDetails encryption;
    private UUID workspaceUID;
    private Map<String, Object> extraProperties;
    private ManagedVirtualNetworkSettings managedVirtualNetworkSettings;
    private WorkspaceRepositoryConfiguration workspaceRepositoryConfiguration;
    private PurviewConfiguration purviewConfiguration;
    private String adlaResourceId;
    private String type;
    private String name;
    private String id;

    public ManagedIdentity getIdentity() {
        return this.identity;
    }

    public Workspace setIdentity(ManagedIdentity identity) {
        this.identity = identity;
        return this;
    }

    public DataLakeStorageAccountDetails getDefaultDataLakeStorage() {
        return this.defaultDataLakeStorage;
    }

    public Workspace setDefaultDataLakeStorage(DataLakeStorageAccountDetails defaultDataLakeStorage) {
        this.defaultDataLakeStorage = defaultDataLakeStorage;
        return this;
    }

    public String getSqlAdministratorLoginPassword() {
        return this.sqlAdministratorLoginPassword;
    }

    public Workspace setSqlAdministratorLoginPassword(String sqlAdministratorLoginPassword) {
        this.sqlAdministratorLoginPassword = sqlAdministratorLoginPassword;
        return this;
    }

    public String getManagedResourceGroupName() {
        return this.managedResourceGroupName;
    }

    public Workspace setManagedResourceGroupName(String managedResourceGroupName) {
        this.managedResourceGroupName = managedResourceGroupName;
        return this;
    }

    public String getProvisioningState() {
        return this.provisioningState;
    }

    public String getSqlAdministratorLogin() {
        return this.sqlAdministratorLogin;
    }

    public Workspace setSqlAdministratorLogin(String sqlAdministratorLogin) {
        this.sqlAdministratorLogin = sqlAdministratorLogin;
        return this;
    }

    public VirtualNetworkProfile getVirtualNetworkProfile() {
        return this.virtualNetworkProfile;
    }

    public Workspace setVirtualNetworkProfile(VirtualNetworkProfile virtualNetworkProfile) {
        this.virtualNetworkProfile = virtualNetworkProfile;
        return this;
    }

    public Map<String, String> getConnectivityEndpoints() {
        return this.connectivityEndpoints;
    }

    public Workspace setConnectivityEndpoints(Map<String, String> connectivityEndpoints) {
        this.connectivityEndpoints = connectivityEndpoints;
        return this;
    }

    public String getManagedVirtualNetwork() {
        return this.managedVirtualNetwork;
    }

    public Workspace setManagedVirtualNetwork(String managedVirtualNetwork) {
        this.managedVirtualNetwork = managedVirtualNetwork;
        return this;
    }

    public List<PrivateEndpointConnection> getPrivateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public Workspace setPrivateEndpointConnections(List<PrivateEndpointConnection> privateEndpointConnections) {
        this.privateEndpointConnections = privateEndpointConnections;
        return this;
    }

    public EncryptionDetails getEncryption() {
        return this.encryption;
    }

    public Workspace setEncryption(EncryptionDetails encryption) {
        this.encryption = encryption;
        return this;
    }

    public UUID getWorkspaceUID() {
        return this.workspaceUID;
    }

    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    public ManagedVirtualNetworkSettings getManagedVirtualNetworkSettings() {
        return this.managedVirtualNetworkSettings;
    }

    public Workspace setManagedVirtualNetworkSettings(ManagedVirtualNetworkSettings managedVirtualNetworkSettings) {
        this.managedVirtualNetworkSettings = managedVirtualNetworkSettings;
        return this;
    }

    public WorkspaceRepositoryConfiguration getWorkspaceRepositoryConfiguration() {
        return this.workspaceRepositoryConfiguration;
    }

    public Workspace setWorkspaceRepositoryConfiguration(WorkspaceRepositoryConfiguration workspaceRepositoryConfiguration) {
        this.workspaceRepositoryConfiguration = workspaceRepositoryConfiguration;
        return this;
    }

    public PurviewConfiguration getPurviewConfiguration() {
        return this.purviewConfiguration;
    }

    public Workspace setPurviewConfiguration(PurviewConfiguration purviewConfiguration) {
        this.purviewConfiguration = purviewConfiguration;
        return this;
    }

    public String getAdlaResourceId() {
        return this.adlaResourceId;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Workspace setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    @Override
    public Workspace setLocation(String location) {
        super.setLocation(location);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.getLocation());
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        if (this.defaultDataLakeStorage != null || this.sqlAdministratorLoginPassword != null || this.managedResourceGroupName != null || this.provisioningState != null || this.sqlAdministratorLogin != null || this.virtualNetworkProfile != null || this.connectivityEndpoints != null || this.managedVirtualNetwork != null || this.privateEndpointConnections != null || this.encryption != null || this.workspaceUID != null || this.extraProperties != null || this.managedVirtualNetworkSettings != null || this.workspaceRepositoryConfiguration != null || this.purviewConfiguration != null || this.adlaResourceId != null) {
            jsonWriter.writeStartObject("properties");
            jsonWriter.writeJsonField("defaultDataLakeStorage", (JsonSerializable)this.defaultDataLakeStorage);
            jsonWriter.writeStringField("sqlAdministratorLoginPassword", this.sqlAdministratorLoginPassword);
            jsonWriter.writeStringField("managedResourceGroupName", this.managedResourceGroupName);
            jsonWriter.writeStringField("sqlAdministratorLogin", this.sqlAdministratorLogin);
            jsonWriter.writeJsonField("virtualNetworkProfile", (JsonSerializable)this.virtualNetworkProfile);
            jsonWriter.writeMapField("connectivityEndpoints", this.connectivityEndpoints, (writer, element) -> writer.writeString(element));
            jsonWriter.writeStringField("managedVirtualNetwork", this.managedVirtualNetwork);
            jsonWriter.writeArrayField("privateEndpointConnections", this.privateEndpointConnections, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeJsonField("encryption", (JsonSerializable)this.encryption);
            jsonWriter.writeJsonField("managedVirtualNetworkSettings", (JsonSerializable)this.managedVirtualNetworkSettings);
            jsonWriter.writeJsonField("workspaceRepositoryConfiguration", (JsonSerializable)this.workspaceRepositoryConfiguration);
            jsonWriter.writeJsonField("purviewConfiguration", (JsonSerializable)this.purviewConfiguration);
            jsonWriter.writeEndObject();
        }
        return jsonWriter.writeEndObject();
    }

    public static Workspace fromJson(JsonReader jsonReader) throws IOException {
        return (Workspace)jsonReader.readObject(reader -> {
            Workspace deserializedWorkspace = new Workspace();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedWorkspace.setLocation(reader.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedWorkspace.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedWorkspace.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWorkspace.type = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedWorkspace.setTags(tags);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedWorkspace.identity = ManagedIdentity.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("defaultDataLakeStorage".equals(fieldName)) {
                            deserializedWorkspace.defaultDataLakeStorage = DataLakeStorageAccountDetails.fromJson(reader);
                            continue;
                        }
                        if ("sqlAdministratorLoginPassword".equals(fieldName)) {
                            deserializedWorkspace.sqlAdministratorLoginPassword = reader.getString();
                            continue;
                        }
                        if ("managedResourceGroupName".equals(fieldName)) {
                            deserializedWorkspace.managedResourceGroupName = reader.getString();
                            continue;
                        }
                        if ("provisioningState".equals(fieldName)) {
                            deserializedWorkspace.provisioningState = reader.getString();
                            continue;
                        }
                        if ("sqlAdministratorLogin".equals(fieldName)) {
                            deserializedWorkspace.sqlAdministratorLogin = reader.getString();
                            continue;
                        }
                        if ("virtualNetworkProfile".equals(fieldName)) {
                            deserializedWorkspace.virtualNetworkProfile = VirtualNetworkProfile.fromJson(reader);
                            continue;
                        }
                        if ("connectivityEndpoints".equals(fieldName)) {
                            Map connectivityEndpoints;
                            deserializedWorkspace.connectivityEndpoints = connectivityEndpoints = reader.readMap(reader1 -> reader1.getString());
                            continue;
                        }
                        if ("managedVirtualNetwork".equals(fieldName)) {
                            deserializedWorkspace.managedVirtualNetwork = reader.getString();
                            continue;
                        }
                        if ("privateEndpointConnections".equals(fieldName)) {
                            List privateEndpointConnections;
                            deserializedWorkspace.privateEndpointConnections = privateEndpointConnections = reader.readArray(reader1 -> PrivateEndpointConnection.fromJson(reader1));
                            continue;
                        }
                        if ("encryption".equals(fieldName)) {
                            deserializedWorkspace.encryption = EncryptionDetails.fromJson(reader);
                            continue;
                        }
                        if ("workspaceUID".equals(fieldName)) {
                            deserializedWorkspace.workspaceUID = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                            continue;
                        }
                        if ("extraProperties".equals(fieldName)) {
                            Map extraProperties;
                            deserializedWorkspace.extraProperties = extraProperties = reader.readMap(reader1 -> reader1.readUntyped());
                            continue;
                        }
                        if ("managedVirtualNetworkSettings".equals(fieldName)) {
                            deserializedWorkspace.managedVirtualNetworkSettings = ManagedVirtualNetworkSettings.fromJson(reader);
                            continue;
                        }
                        if ("workspaceRepositoryConfiguration".equals(fieldName)) {
                            deserializedWorkspace.workspaceRepositoryConfiguration = WorkspaceRepositoryConfiguration.fromJson(reader);
                            continue;
                        }
                        if ("purviewConfiguration".equals(fieldName)) {
                            deserializedWorkspace.purviewConfiguration = PurviewConfiguration.fromJson(reader);
                            continue;
                        }
                        if ("adlaResourceId".equals(fieldName)) {
                            deserializedWorkspace.adlaResourceId = reader.getString();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkspace;
        });
    }
}

