/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.analytics.synapse.artifacts.models.WebAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.WebLinkedServiceTypeProperties;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class WebClientCertificateAuthentication
extends WebLinkedServiceTypeProperties {
    private WebAuthenticationType authenticationType = WebAuthenticationType.CLIENT_CERTIFICATE;
    private SecretBase pfx;
    private SecretBase password;

    @Override
    public WebAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public SecretBase getPfx() {
        return this.pfx;
    }

    public WebClientCertificateAuthentication setPfx(SecretBase pfx) {
        this.pfx = pfx;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public WebClientCertificateAuthentication setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    @Override
    public WebClientCertificateAuthentication setUrl(Object url) {
        super.setUrl(url);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("url", this.getUrl());
        jsonWriter.writeJsonField("pfx", (JsonSerializable)this.pfx);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        return jsonWriter.writeEndObject();
    }

    public static WebClientCertificateAuthentication fromJson(JsonReader jsonReader) throws IOException {
        return (WebClientCertificateAuthentication)jsonReader.readObject(reader -> {
            WebClientCertificateAuthentication deserializedWebClientCertificateAuthentication = new WebClientCertificateAuthentication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedWebClientCertificateAuthentication.setUrl(reader.readUntyped());
                    continue;
                }
                if ("pfx".equals(fieldName)) {
                    deserializedWebClientCertificateAuthentication.pfx = SecretBase.fromJson(reader);
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedWebClientCertificateAuthentication.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedWebClientCertificateAuthentication.authenticationType = WebAuthenticationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebClientCertificateAuthentication;
        });
    }
}

