/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.analytics.synapse.artifacts.models.WebAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.WebLinkedServiceTypeProperties;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class WebBasicAuthentication
extends WebLinkedServiceTypeProperties {
    private WebAuthenticationType authenticationType = WebAuthenticationType.BASIC;
    private Object username;
    private SecretBase password;

    @Override
    public WebAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public Object getUsername() {
        return this.username;
    }

    public WebBasicAuthentication setUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public WebBasicAuthentication setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    @Override
    public WebBasicAuthentication setUrl(Object url) {
        super.setUrl(url);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("url", this.getUrl());
        jsonWriter.writeUntypedField("username", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        return jsonWriter.writeEndObject();
    }

    public static WebBasicAuthentication fromJson(JsonReader jsonReader) throws IOException {
        return (WebBasicAuthentication)jsonReader.readObject(reader -> {
            WebBasicAuthentication deserializedWebBasicAuthentication = new WebBasicAuthentication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedWebBasicAuthentication.setUrl(reader.readUntyped());
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedWebBasicAuthentication.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedWebBasicAuthentication.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedWebBasicAuthentication.authenticationType = WebAuthenticationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebBasicAuthentication;
        });
    }
}

