/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Activity;
import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.ControlActivity;
import com.azure.analytics.synapse.artifacts.models.Expression;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class UntilActivity
extends ControlActivity {
    private String type = "Until";
    private Expression expression;
    private Object timeout;
    private List<Activity> activities;

    @Override
    public String getType() {
        return this.type;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public UntilActivity setExpression(Expression expression) {
        this.expression = expression;
        return this;
    }

    public Object getTimeout() {
        return this.timeout;
    }

    public UntilActivity setTimeout(Object timeout) {
        this.timeout = timeout;
        return this;
    }

    public List<Activity> getActivities() {
        return this.activities;
    }

    public UntilActivity setActivities(List<Activity> activities) {
        this.activities = activities;
        return this;
    }

    @Override
    public UntilActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public UntilActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public UntilActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public UntilActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public UntilActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public UntilActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        if (this.expression != null || this.timeout != null || this.activities != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeJsonField("expression", (JsonSerializable)this.expression);
            if (this.timeout != null) {
                jsonWriter.writeUntypedField("timeout", this.timeout);
            }
            jsonWriter.writeArrayField("activities", this.activities, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static UntilActivity fromJson(JsonReader jsonReader) throws IOException {
        return (UntilActivity)jsonReader.readObject(reader -> {
            UntilActivity deserializedUntilActivity = new UntilActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedUntilActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedUntilActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedUntilActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedUntilActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedUntilActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedUntilActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedUntilActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("expression".equals(fieldName)) {
                            deserializedUntilActivity.expression = Expression.fromJson(reader);
                            continue;
                        }
                        if ("timeout".equals(fieldName)) {
                            deserializedUntilActivity.timeout = reader.readUntyped();
                            continue;
                        }
                        if ("activities".equals(fieldName)) {
                            List activities;
                            deserializedUntilActivity.activities = activities = reader.readArray(reader1 -> Activity.fromJson(reader1));
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedUntilActivity.setAdditionalProperties(additionalProperties);
            return deserializedUntilActivity;
        });
    }
}

