/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.DataFlowReference;
import com.azure.analytics.synapse.artifacts.models.DatasetReference;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class Transformation
implements JsonSerializable<Transformation> {
    private String name;
    private String description;
    private DatasetReference dataset;
    private LinkedServiceReference linkedService;
    private DataFlowReference flowlet;

    public String getName() {
        return this.name;
    }

    public Transformation setName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Transformation setDescription(String description) {
        this.description = description;
        return this;
    }

    public DatasetReference getDataset() {
        return this.dataset;
    }

    public Transformation setDataset(DatasetReference dataset) {
        this.dataset = dataset;
        return this;
    }

    public LinkedServiceReference getLinkedService() {
        return this.linkedService;
    }

    public Transformation setLinkedService(LinkedServiceReference linkedService) {
        this.linkedService = linkedService;
        return this;
    }

    public DataFlowReference getFlowlet() {
        return this.flowlet;
    }

    public Transformation setFlowlet(DataFlowReference flowlet) {
        this.flowlet = flowlet;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("dataset", (JsonSerializable)this.dataset);
        jsonWriter.writeJsonField("linkedService", (JsonSerializable)this.linkedService);
        jsonWriter.writeJsonField("flowlet", (JsonSerializable)this.flowlet);
        return jsonWriter.writeEndObject();
    }

    public static Transformation fromJson(JsonReader jsonReader) throws IOException {
        return (Transformation)jsonReader.readObject(reader -> {
            Transformation deserializedTransformation = new Transformation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedTransformation.name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedTransformation.description = reader.getString();
                    continue;
                }
                if ("dataset".equals(fieldName)) {
                    deserializedTransformation.dataset = DatasetReference.fromJson(reader);
                    continue;
                }
                if ("linkedService".equals(fieldName)) {
                    deserializedTransformation.linkedService = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("flowlet".equals(fieldName)) {
                    deserializedTransformation.flowlet = DataFlowReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTransformation;
        });
    }
}

