/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public class TrackedResource
extends Resource {
    private Map<String, String> tags;
    private String location;
    private String type;
    private String name;
    private String id;

    public Map<String, String> getTags() {
        return this.tags;
    }

    public TrackedResource setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public TrackedResource setLocation(String location) {
        this.location = location;
        return this;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static TrackedResource fromJson(JsonReader jsonReader) throws IOException {
        return (TrackedResource)jsonReader.readObject(reader -> {
            TrackedResource deserializedTrackedResource = new TrackedResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTrackedResource.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedTrackedResource.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedTrackedResource.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedTrackedResource.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedTrackedResource.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTrackedResource;
        });
    }
}

