/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AzureBlobFSWriteSettings;
import com.azure.analytics.synapse.artifacts.models.AzureBlobStorageWriteSettings;
import com.azure.analytics.synapse.artifacts.models.AzureDataLakeStoreWriteSettings;
import com.azure.analytics.synapse.artifacts.models.AzureFileStorageWriteSettings;
import com.azure.analytics.synapse.artifacts.models.FileServerWriteSettings;
import com.azure.analytics.synapse.artifacts.models.LakeHouseWriteSettings;
import com.azure.analytics.synapse.artifacts.models.MetadataItem;
import com.azure.analytics.synapse.artifacts.models.SftpWriteSettings;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StoreWriteSettings
implements JsonSerializable<StoreWriteSettings> {
    private String type = "StoreWriteSettings";
    private Object maxConcurrentConnections;
    private Object copyBehavior;
    private List<MetadataItem> metadata;
    private Map<String, Object> additionalProperties;

    public String getType() {
        return this.type;
    }

    public Object getMaxConcurrentConnections() {
        return this.maxConcurrentConnections;
    }

    public StoreWriteSettings setMaxConcurrentConnections(Object maxConcurrentConnections) {
        this.maxConcurrentConnections = maxConcurrentConnections;
        return this;
    }

    public Object getCopyBehavior() {
        return this.copyBehavior;
    }

    public StoreWriteSettings setCopyBehavior(Object copyBehavior) {
        this.copyBehavior = copyBehavior;
        return this;
    }

    public List<MetadataItem> getMetadata() {
        return this.metadata;
    }

    public StoreWriteSettings setMetadata(List<MetadataItem> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public StoreWriteSettings setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        if (this.maxConcurrentConnections != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections);
        }
        if (this.copyBehavior != null) {
            jsonWriter.writeUntypedField("copyBehavior", this.copyBehavior);
        }
        jsonWriter.writeArrayField("metadata", this.metadata, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static StoreWriteSettings fromJson(JsonReader jsonReader) throws IOException {
        return (StoreWriteSettings)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                StoreWriteSettings storeWriteSettings;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("SftpWriteSettings".equals(discriminatorValue)) {
                    storeWriteSettings = SftpWriteSettings.fromJson(readerToUse.reset());
                    return storeWriteSettings;
                }
                if ("AzureBlobStorageWriteSettings".equals(discriminatorValue)) {
                    storeWriteSettings = AzureBlobStorageWriteSettings.fromJson(readerToUse.reset());
                    return storeWriteSettings;
                }
                if ("AzureBlobFSWriteSettings".equals(discriminatorValue)) {
                    storeWriteSettings = AzureBlobFSWriteSettings.fromJson(readerToUse.reset());
                    return storeWriteSettings;
                }
                if ("AzureDataLakeStoreWriteSettings".equals(discriminatorValue)) {
                    storeWriteSettings = AzureDataLakeStoreWriteSettings.fromJson(readerToUse.reset());
                    return storeWriteSettings;
                }
                if ("FileServerWriteSettings".equals(discriminatorValue)) {
                    storeWriteSettings = FileServerWriteSettings.fromJson(readerToUse.reset());
                    return storeWriteSettings;
                }
                if ("AzureFileStorageWriteSettings".equals(discriminatorValue)) {
                    storeWriteSettings = AzureFileStorageWriteSettings.fromJson(readerToUse.reset());
                    return storeWriteSettings;
                }
                if ("LakeHouseWriteSettings".equals(discriminatorValue)) {
                    storeWriteSettings = LakeHouseWriteSettings.fromJson(readerToUse.reset());
                    return storeWriteSettings;
                }
                storeWriteSettings = StoreWriteSettings.fromJsonKnownDiscriminator(readerToUse.reset());
                return storeWriteSettings;
            }
        });
    }

    static StoreWriteSettings fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (StoreWriteSettings)jsonReader.readObject(reader -> {
            StoreWriteSettings deserializedStoreWriteSettings = new StoreWriteSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedStoreWriteSettings.type = reader.getString();
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedStoreWriteSettings.maxConcurrentConnections = reader.readUntyped();
                    continue;
                }
                if ("copyBehavior".equals(fieldName)) {
                    deserializedStoreWriteSettings.copyBehavior = reader.readUntyped();
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata;
                    deserializedStoreWriteSettings.metadata = metadata = reader.readArray(reader1 -> MetadataItem.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedStoreWriteSettings.additionalProperties = additionalProperties;
            return deserializedStoreWriteSettings;
        });
    }
}

