/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.SsisAccessCredential;
import com.azure.analytics.synapse.artifacts.models.SsisLogLocationType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class SsisLogLocation
implements JsonSerializable<SsisLogLocation> {
    private Object logPath;
    private SsisLogLocationType type;
    private SsisAccessCredential accessCredential;
    private Object logRefreshInterval;

    public Object getLogPath() {
        return this.logPath;
    }

    public SsisLogLocation setLogPath(Object logPath) {
        this.logPath = logPath;
        return this;
    }

    public SsisLogLocationType getType() {
        return this.type;
    }

    public SsisLogLocation setType(SsisLogLocationType type) {
        this.type = type;
        return this;
    }

    public SsisAccessCredential getAccessCredential() {
        return this.accessCredential;
    }

    public SsisLogLocation setAccessCredential(SsisAccessCredential accessCredential) {
        this.accessCredential = accessCredential;
        return this;
    }

    public Object getLogRefreshInterval() {
        return this.logRefreshInterval;
    }

    public SsisLogLocation setLogRefreshInterval(Object logRefreshInterval) {
        this.logRefreshInterval = logRefreshInterval;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("logPath", this.logPath);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        if (this.accessCredential != null || this.logRefreshInterval != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeJsonField("accessCredential", (JsonSerializable)this.accessCredential);
            if (this.logRefreshInterval != null) {
                jsonWriter.writeUntypedField("logRefreshInterval", this.logRefreshInterval);
            }
            jsonWriter.writeEndObject();
        }
        return jsonWriter.writeEndObject();
    }

    public static SsisLogLocation fromJson(JsonReader jsonReader) throws IOException {
        return (SsisLogLocation)jsonReader.readObject(reader -> {
            SsisLogLocation deserializedSsisLogLocation = new SsisLogLocation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("logPath".equals(fieldName)) {
                    deserializedSsisLogLocation.logPath = reader.readUntyped();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSsisLogLocation.type = SsisLogLocationType.fromString(reader.getString());
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("accessCredential".equals(fieldName)) {
                            deserializedSsisLogLocation.accessCredential = SsisAccessCredential.fromJson(reader);
                            continue;
                        }
                        if ("logRefreshInterval".equals(fieldName)) {
                            deserializedSsisLogLocation.logRefreshInterval = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSsisLogLocation;
        });
    }
}

