/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.SqlScriptContent;
import com.azure.analytics.synapse.artifacts.models.SqlScriptFolder;
import com.azure.analytics.synapse.artifacts.models.SqlScriptType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SqlScript
implements JsonSerializable<SqlScript> {
    private String description;
    private SqlScriptType type;
    private SqlScriptContent content;
    private SqlScriptFolder folder;
    private Map<String, Object> additionalProperties;

    public String getDescription() {
        return this.description;
    }

    public SqlScript setDescription(String description) {
        this.description = description;
        return this;
    }

    public SqlScriptType getType() {
        return this.type;
    }

    public SqlScript setType(SqlScriptType type) {
        this.type = type;
        return this;
    }

    public SqlScriptContent getContent() {
        return this.content;
    }

    public SqlScript setContent(SqlScriptContent content) {
        this.content = content;
        return this;
    }

    public SqlScriptFolder getFolder() {
        return this.folder;
    }

    public SqlScript setFolder(SqlScriptFolder folder) {
        this.folder = folder;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public SqlScript setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("content", (JsonSerializable)this.content);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SqlScript fromJson(JsonReader jsonReader) throws IOException {
        return (SqlScript)jsonReader.readObject(reader -> {
            SqlScript deserializedSqlScript = new SqlScript();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    deserializedSqlScript.content = SqlScriptContent.fromJson(reader);
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSqlScript.description = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSqlScript.type = SqlScriptType.fromString(reader.getString());
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedSqlScript.folder = SqlScriptFolder.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSqlScript.additionalProperties = additionalProperties;
            return deserializedSqlScript;
        });
    }
}

