/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CreateMode;
import com.azure.analytics.synapse.artifacts.models.Sku;
import com.azure.analytics.synapse.artifacts.models.TrackedResource;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public class SqlPool
extends TrackedResource {
    private Sku sku;
    private Long maxSizeBytes;
    private String collation;
    private String sourceDatabaseId;
    private String recoverableDatabaseId;
    private String provisioningState;
    private String status;
    private String restorePointInTime;
    private CreateMode createMode;
    private OffsetDateTime creationDate;
    private String type;
    private String name;
    private String id;

    public Sku getSku() {
        return this.sku;
    }

    public SqlPool setSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    public Long getMaxSizeBytes() {
        return this.maxSizeBytes;
    }

    public SqlPool setMaxSizeBytes(Long maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
        return this;
    }

    public String getCollation() {
        return this.collation;
    }

    public SqlPool setCollation(String collation) {
        this.collation = collation;
        return this;
    }

    public String getSourceDatabaseId() {
        return this.sourceDatabaseId;
    }

    public SqlPool setSourceDatabaseId(String sourceDatabaseId) {
        this.sourceDatabaseId = sourceDatabaseId;
        return this;
    }

    public String getRecoverableDatabaseId() {
        return this.recoverableDatabaseId;
    }

    public SqlPool setRecoverableDatabaseId(String recoverableDatabaseId) {
        this.recoverableDatabaseId = recoverableDatabaseId;
        return this;
    }

    public String getProvisioningState() {
        return this.provisioningState;
    }

    public SqlPool setProvisioningState(String provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public SqlPool setStatus(String status) {
        this.status = status;
        return this;
    }

    public String getRestorePointInTime() {
        return this.restorePointInTime;
    }

    public SqlPool setRestorePointInTime(String restorePointInTime) {
        this.restorePointInTime = restorePointInTime;
        return this;
    }

    public CreateMode getCreateMode() {
        return this.createMode;
    }

    public SqlPool setCreateMode(CreateMode createMode) {
        this.createMode = createMode;
        return this;
    }

    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    public SqlPool setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public SqlPool setTags(Map<String, String> tags) {
        super.setTags(tags);
        return this;
    }

    @Override
    public SqlPool setLocation(String location) {
        super.setLocation(location);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.getLocation());
        jsonWriter.writeMapField("tags", this.getTags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        if (this.maxSizeBytes != null || this.collation != null || this.sourceDatabaseId != null || this.recoverableDatabaseId != null || this.provisioningState != null || this.status != null || this.restorePointInTime != null || this.createMode != null || this.creationDate != null) {
            jsonWriter.writeStartObject("properties");
            jsonWriter.writeNumberField("maxSizeBytes", (Number)this.maxSizeBytes);
            jsonWriter.writeStringField("collation", this.collation);
            jsonWriter.writeStringField("sourceDatabaseId", this.sourceDatabaseId);
            jsonWriter.writeStringField("recoverableDatabaseId", this.recoverableDatabaseId);
            jsonWriter.writeStringField("provisioningState", this.provisioningState);
            jsonWriter.writeStringField("status", this.status);
            jsonWriter.writeStringField("restorePointInTime", this.restorePointInTime);
            jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
            jsonWriter.writeStringField("creationDate", this.creationDate == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.creationDate));
            jsonWriter.writeEndObject();
        }
        return jsonWriter.writeEndObject();
    }

    public static SqlPool fromJson(JsonReader jsonReader) throws IOException {
        return (SqlPool)jsonReader.readObject(reader -> {
            SqlPool deserializedSqlPool = new SqlPool();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("location".equals(fieldName)) {
                    deserializedSqlPool.setLocation(reader.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedSqlPool.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSqlPool.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSqlPool.type = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedSqlPool.setTags(tags);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedSqlPool.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("maxSizeBytes".equals(fieldName)) {
                            deserializedSqlPool.maxSizeBytes = (Long)reader.getNullable(JsonReader::getLong);
                            continue;
                        }
                        if ("collation".equals(fieldName)) {
                            deserializedSqlPool.collation = reader.getString();
                            continue;
                        }
                        if ("sourceDatabaseId".equals(fieldName)) {
                            deserializedSqlPool.sourceDatabaseId = reader.getString();
                            continue;
                        }
                        if ("recoverableDatabaseId".equals(fieldName)) {
                            deserializedSqlPool.recoverableDatabaseId = reader.getString();
                            continue;
                        }
                        if ("provisioningState".equals(fieldName)) {
                            deserializedSqlPool.provisioningState = reader.getString();
                            continue;
                        }
                        if ("status".equals(fieldName)) {
                            deserializedSqlPool.status = reader.getString();
                            continue;
                        }
                        if ("restorePointInTime".equals(fieldName)) {
                            deserializedSqlPool.restorePointInTime = reader.getString();
                            continue;
                        }
                        if ("createMode".equals(fieldName)) {
                            deserializedSqlPool.createMode = CreateMode.fromString(reader.getString());
                            continue;
                        }
                        if ("creationDate".equals(fieldName)) {
                            deserializedSqlPool.creationDate = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSqlPool;
        });
    }
}

