/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.PluginCurrentState;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class SparkServicePlugin
implements JsonSerializable<SparkServicePlugin> {
    private OffsetDateTime preparationStartedAt;
    private OffsetDateTime resourceAcquisitionStartedAt;
    private OffsetDateTime submissionStartedAt;
    private OffsetDateTime monitoringStartedAt;
    private OffsetDateTime cleanupStartedAt;
    private PluginCurrentState currentState;

    public OffsetDateTime getPreparationStartedAt() {
        return this.preparationStartedAt;
    }

    public SparkServicePlugin setPreparationStartedAt(OffsetDateTime preparationStartedAt) {
        this.preparationStartedAt = preparationStartedAt;
        return this;
    }

    public OffsetDateTime getResourceAcquisitionStartedAt() {
        return this.resourceAcquisitionStartedAt;
    }

    public SparkServicePlugin setResourceAcquisitionStartedAt(OffsetDateTime resourceAcquisitionStartedAt) {
        this.resourceAcquisitionStartedAt = resourceAcquisitionStartedAt;
        return this;
    }

    public OffsetDateTime getSubmissionStartedAt() {
        return this.submissionStartedAt;
    }

    public SparkServicePlugin setSubmissionStartedAt(OffsetDateTime submissionStartedAt) {
        this.submissionStartedAt = submissionStartedAt;
        return this;
    }

    public OffsetDateTime getMonitoringStartedAt() {
        return this.monitoringStartedAt;
    }

    public SparkServicePlugin setMonitoringStartedAt(OffsetDateTime monitoringStartedAt) {
        this.monitoringStartedAt = monitoringStartedAt;
        return this;
    }

    public OffsetDateTime getCleanupStartedAt() {
        return this.cleanupStartedAt;
    }

    public SparkServicePlugin setCleanupStartedAt(OffsetDateTime cleanupStartedAt) {
        this.cleanupStartedAt = cleanupStartedAt;
        return this;
    }

    public PluginCurrentState getCurrentState() {
        return this.currentState;
    }

    public SparkServicePlugin setCurrentState(PluginCurrentState currentState) {
        this.currentState = currentState;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("preparationStartedAt", this.preparationStartedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.preparationStartedAt));
        jsonWriter.writeStringField("resourceAcquisitionStartedAt", this.resourceAcquisitionStartedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.resourceAcquisitionStartedAt));
        jsonWriter.writeStringField("submissionStartedAt", this.submissionStartedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.submissionStartedAt));
        jsonWriter.writeStringField("monitoringStartedAt", this.monitoringStartedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.monitoringStartedAt));
        jsonWriter.writeStringField("cleanupStartedAt", this.cleanupStartedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.cleanupStartedAt));
        jsonWriter.writeStringField("currentState", this.currentState == null ? null : this.currentState.toString());
        return jsonWriter.writeEndObject();
    }

    public static SparkServicePlugin fromJson(JsonReader jsonReader) throws IOException {
        return (SparkServicePlugin)jsonReader.readObject(reader -> {
            SparkServicePlugin deserializedSparkServicePlugin = new SparkServicePlugin();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("preparationStartedAt".equals(fieldName)) {
                    deserializedSparkServicePlugin.preparationStartedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("resourceAcquisitionStartedAt".equals(fieldName)) {
                    deserializedSparkServicePlugin.resourceAcquisitionStartedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("submissionStartedAt".equals(fieldName)) {
                    deserializedSparkServicePlugin.submissionStartedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("monitoringStartedAt".equals(fieldName)) {
                    deserializedSparkServicePlugin.monitoringStartedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("cleanupStartedAt".equals(fieldName)) {
                    deserializedSparkServicePlugin.cleanupStartedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("currentState".equals(fieldName)) {
                    deserializedSparkServicePlugin.currentState = PluginCurrentState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSparkServicePlugin;
        });
    }
}

