/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.SparkErrorSource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class SparkServiceError
implements JsonSerializable<SparkServiceError> {
    private String message;
    private String errorCode;
    private SparkErrorSource source;

    public String getMessage() {
        return this.message;
    }

    public SparkServiceError setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public SparkServiceError setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public SparkErrorSource getSource() {
        return this.source;
    }

    public SparkServiceError setSource(SparkErrorSource source) {
        this.source = source;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("errorCode", this.errorCode);
        jsonWriter.writeStringField("source", this.source == null ? null : this.source.toString());
        return jsonWriter.writeEndObject();
    }

    public static SparkServiceError fromJson(JsonReader jsonReader) throws IOException {
        return (SparkServiceError)jsonReader.readObject(reader -> {
            SparkServiceError deserializedSparkServiceError = new SparkServiceError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("message".equals(fieldName)) {
                    deserializedSparkServiceError.message = reader.getString();
                    continue;
                }
                if ("errorCode".equals(fieldName)) {
                    deserializedSparkServiceError.errorCode = reader.getString();
                    continue;
                }
                if ("source".equals(fieldName)) {
                    deserializedSparkServiceError.source = SparkErrorSource.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSparkServiceError;
        });
    }
}

