/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class SparkRequest
implements JsonSerializable<SparkRequest> {
    private String name;
    private String file;
    private String className;
    private List<String> arguments;
    private List<String> jars;
    private List<String> pythonFiles;
    private List<String> files;
    private List<String> archives;
    private Map<String, String> configuration;
    private String driverMemory;
    private Integer driverCores;
    private String executorMemory;
    private Integer executorCores;
    private Integer executorCount;

    public String getName() {
        return this.name;
    }

    public SparkRequest setName(String name) {
        this.name = name;
        return this;
    }

    public String getFile() {
        return this.file;
    }

    public SparkRequest setFile(String file) {
        this.file = file;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public SparkRequest setClassName(String className) {
        this.className = className;
        return this;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public SparkRequest setArguments(List<String> arguments) {
        this.arguments = arguments;
        return this;
    }

    public List<String> getJars() {
        return this.jars;
    }

    public SparkRequest setJars(List<String> jars) {
        this.jars = jars;
        return this;
    }

    public List<String> getPythonFiles() {
        return this.pythonFiles;
    }

    public SparkRequest setPythonFiles(List<String> pythonFiles) {
        this.pythonFiles = pythonFiles;
        return this;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public SparkRequest setFiles(List<String> files) {
        this.files = files;
        return this;
    }

    public List<String> getArchives() {
        return this.archives;
    }

    public SparkRequest setArchives(List<String> archives) {
        this.archives = archives;
        return this;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public SparkRequest setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
        return this;
    }

    public String getDriverMemory() {
        return this.driverMemory;
    }

    public SparkRequest setDriverMemory(String driverMemory) {
        this.driverMemory = driverMemory;
        return this;
    }

    public Integer getDriverCores() {
        return this.driverCores;
    }

    public SparkRequest setDriverCores(Integer driverCores) {
        this.driverCores = driverCores;
        return this;
    }

    public String getExecutorMemory() {
        return this.executorMemory;
    }

    public SparkRequest setExecutorMemory(String executorMemory) {
        this.executorMemory = executorMemory;
        return this;
    }

    public Integer getExecutorCores() {
        return this.executorCores;
    }

    public SparkRequest setExecutorCores(Integer executorCores) {
        this.executorCores = executorCores;
        return this;
    }

    public Integer getExecutorCount() {
        return this.executorCount;
    }

    public SparkRequest setExecutorCount(Integer executorCount) {
        this.executorCount = executorCount;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("file", this.file);
        jsonWriter.writeStringField("className", this.className);
        jsonWriter.writeArrayField("args", this.arguments, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("jars", this.jars, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("pyFiles", this.pythonFiles, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("files", this.files, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("archives", this.archives, (writer, element) -> writer.writeString(element));
        jsonWriter.writeMapField("conf", this.configuration, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("driverMemory", this.driverMemory);
        jsonWriter.writeNumberField("driverCores", (Number)this.driverCores);
        jsonWriter.writeStringField("executorMemory", this.executorMemory);
        jsonWriter.writeNumberField("executorCores", (Number)this.executorCores);
        jsonWriter.writeNumberField("numExecutors", (Number)this.executorCount);
        return jsonWriter.writeEndObject();
    }

    public static SparkRequest fromJson(JsonReader jsonReader) throws IOException {
        return (SparkRequest)jsonReader.readObject(reader -> {
            SparkRequest deserializedSparkRequest = new SparkRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSparkRequest.name = reader.getString();
                    continue;
                }
                if ("file".equals(fieldName)) {
                    deserializedSparkRequest.file = reader.getString();
                    continue;
                }
                if ("className".equals(fieldName)) {
                    deserializedSparkRequest.className = reader.getString();
                    continue;
                }
                if ("args".equals(fieldName)) {
                    List arguments;
                    deserializedSparkRequest.arguments = arguments = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("jars".equals(fieldName)) {
                    List jars;
                    deserializedSparkRequest.jars = jars = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("pyFiles".equals(fieldName)) {
                    List pythonFiles;
                    deserializedSparkRequest.pythonFiles = pythonFiles = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("files".equals(fieldName)) {
                    List files;
                    deserializedSparkRequest.files = files = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("archives".equals(fieldName)) {
                    List archives;
                    deserializedSparkRequest.archives = archives = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("conf".equals(fieldName)) {
                    Map configuration;
                    deserializedSparkRequest.configuration = configuration = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("driverMemory".equals(fieldName)) {
                    deserializedSparkRequest.driverMemory = reader.getString();
                    continue;
                }
                if ("driverCores".equals(fieldName)) {
                    deserializedSparkRequest.driverCores = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("executorMemory".equals(fieldName)) {
                    deserializedSparkRequest.executorMemory = reader.getString();
                    continue;
                }
                if ("executorCores".equals(fieldName)) {
                    deserializedSparkRequest.executorCores = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("numExecutors".equals(fieldName)) {
                    deserializedSparkRequest.executorCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSparkRequest;
        });
    }
}

