/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.analytics.synapse.artifacts.models.SparkAuthenticationType;
import com.azure.analytics.synapse.artifacts.models.SparkServerType;
import com.azure.analytics.synapse.artifacts.models.SparkThriftTransportProtocol;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SparkLinkedService
extends LinkedService {
    private String type = "Spark";
    private Object host;
    private Object port;
    private SparkServerType serverType;
    private SparkThriftTransportProtocol thriftTransportProtocol;
    private SparkAuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private Object httpPath;
    private Object enableSsl;
    private Object enableServerCertificateValidation;
    private Object trustedCertPath;
    private Object useSystemTrustStore;
    private Object allowHostNameCNMismatch;
    private Object allowSelfSignedServerCert;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getHost() {
        return this.host;
    }

    public SparkLinkedService setHost(Object host) {
        this.host = host;
        return this;
    }

    public Object getPort() {
        return this.port;
    }

    public SparkLinkedService setPort(Object port) {
        this.port = port;
        return this;
    }

    public SparkServerType getServerType() {
        return this.serverType;
    }

    public SparkLinkedService setServerType(SparkServerType serverType) {
        this.serverType = serverType;
        return this;
    }

    public SparkThriftTransportProtocol getThriftTransportProtocol() {
        return this.thriftTransportProtocol;
    }

    public SparkLinkedService setThriftTransportProtocol(SparkThriftTransportProtocol thriftTransportProtocol) {
        this.thriftTransportProtocol = thriftTransportProtocol;
        return this;
    }

    public SparkAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public SparkLinkedService setAuthenticationType(SparkAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getUsername() {
        return this.username;
    }

    public SparkLinkedService setUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public SparkLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getHttpPath() {
        return this.httpPath;
    }

    public SparkLinkedService setHttpPath(Object httpPath) {
        this.httpPath = httpPath;
        return this;
    }

    public Object getEnableSsl() {
        return this.enableSsl;
    }

    public SparkLinkedService setEnableSsl(Object enableSsl) {
        this.enableSsl = enableSsl;
        return this;
    }

    public Object getEnableServerCertificateValidation() {
        return this.enableServerCertificateValidation;
    }

    public SparkLinkedService setEnableServerCertificateValidation(Object enableServerCertificateValidation) {
        this.enableServerCertificateValidation = enableServerCertificateValidation;
        return this;
    }

    public Object getTrustedCertPath() {
        return this.trustedCertPath;
    }

    public SparkLinkedService setTrustedCertPath(Object trustedCertPath) {
        this.trustedCertPath = trustedCertPath;
        return this;
    }

    public Object getUseSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    public SparkLinkedService setUseSystemTrustStore(Object useSystemTrustStore) {
        this.useSystemTrustStore = useSystemTrustStore;
        return this;
    }

    public Object getAllowHostNameCNMismatch() {
        return this.allowHostNameCNMismatch;
    }

    public SparkLinkedService setAllowHostNameCNMismatch(Object allowHostNameCNMismatch) {
        this.allowHostNameCNMismatch = allowHostNameCNMismatch;
        return this;
    }

    public Object getAllowSelfSignedServerCert() {
        return this.allowSelfSignedServerCert;
    }

    public SparkLinkedService setAllowSelfSignedServerCert(Object allowSelfSignedServerCert) {
        this.allowSelfSignedServerCert = allowSelfSignedServerCert;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public SparkLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public SparkLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public SparkLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public SparkLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SparkLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public SparkLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.host != null || this.port != null || this.serverType != null || this.thriftTransportProtocol != null || this.authenticationType != null || this.username != null || this.password != null || this.httpPath != null || this.enableSsl != null || this.enableServerCertificateValidation != null || this.trustedCertPath != null || this.useSystemTrustStore != null || this.allowHostNameCNMismatch != null || this.allowSelfSignedServerCert != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("host", this.host);
            jsonWriter.writeUntypedField("port", this.port);
            jsonWriter.writeStringField("serverType", this.serverType == null ? null : this.serverType.toString());
            jsonWriter.writeStringField("thriftTransportProtocol", this.thriftTransportProtocol == null ? null : this.thriftTransportProtocol.toString());
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            if (this.username != null) {
                jsonWriter.writeUntypedField("username", this.username);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.httpPath != null) {
                jsonWriter.writeUntypedField("httpPath", this.httpPath);
            }
            if (this.enableSsl != null) {
                jsonWriter.writeUntypedField("enableSsl", this.enableSsl);
            }
            if (this.enableServerCertificateValidation != null) {
                jsonWriter.writeUntypedField("enableServerCertificateValidation", this.enableServerCertificateValidation);
            }
            if (this.trustedCertPath != null) {
                jsonWriter.writeUntypedField("trustedCertPath", this.trustedCertPath);
            }
            if (this.useSystemTrustStore != null) {
                jsonWriter.writeUntypedField("useSystemTrustStore", this.useSystemTrustStore);
            }
            if (this.allowHostNameCNMismatch != null) {
                jsonWriter.writeUntypedField("allowHostNameCNMismatch", this.allowHostNameCNMismatch);
            }
            if (this.allowSelfSignedServerCert != null) {
                jsonWriter.writeUntypedField("allowSelfSignedServerCert", this.allowSelfSignedServerCert);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SparkLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (SparkLinkedService)jsonReader.readObject(reader -> {
            SparkLinkedService deserializedSparkLinkedService = new SparkLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedSparkLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedSparkLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSparkLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSparkLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSparkLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSparkLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("host".equals(fieldName)) {
                            deserializedSparkLinkedService.host = reader.readUntyped();
                            continue;
                        }
                        if ("port".equals(fieldName)) {
                            deserializedSparkLinkedService.port = reader.readUntyped();
                            continue;
                        }
                        if ("serverType".equals(fieldName)) {
                            deserializedSparkLinkedService.serverType = SparkServerType.fromString(reader.getString());
                            continue;
                        }
                        if ("thriftTransportProtocol".equals(fieldName)) {
                            deserializedSparkLinkedService.thriftTransportProtocol = SparkThriftTransportProtocol.fromString(reader.getString());
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedSparkLinkedService.authenticationType = SparkAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("username".equals(fieldName)) {
                            deserializedSparkLinkedService.username = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedSparkLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("httpPath".equals(fieldName)) {
                            deserializedSparkLinkedService.httpPath = reader.readUntyped();
                            continue;
                        }
                        if ("enableSsl".equals(fieldName)) {
                            deserializedSparkLinkedService.enableSsl = reader.readUntyped();
                            continue;
                        }
                        if ("enableServerCertificateValidation".equals(fieldName)) {
                            deserializedSparkLinkedService.enableServerCertificateValidation = reader.readUntyped();
                            continue;
                        }
                        if ("trustedCertPath".equals(fieldName)) {
                            deserializedSparkLinkedService.trustedCertPath = reader.readUntyped();
                            continue;
                        }
                        if ("useSystemTrustStore".equals(fieldName)) {
                            deserializedSparkLinkedService.useSystemTrustStore = reader.readUntyped();
                            continue;
                        }
                        if ("allowHostNameCNMismatch".equals(fieldName)) {
                            deserializedSparkLinkedService.allowHostNameCNMismatch = reader.readUntyped();
                            continue;
                        }
                        if ("allowSelfSignedServerCert".equals(fieldName)) {
                            deserializedSparkLinkedService.allowSelfSignedServerCert = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedSparkLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSparkLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedSparkLinkedService;
        });
    }
}

