/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

public final class SparkConfiguration
implements JsonSerializable<SparkConfiguration> {
    private String description;
    private Map<String, String> configs;
    private List<String> annotations;
    private String notes;
    private String createdBy;
    private OffsetDateTime created;
    private Map<String, String> configMergeRule;

    public String getDescription() {
        return this.description;
    }

    public SparkConfiguration setDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, String> getConfigs() {
        return this.configs;
    }

    public SparkConfiguration setConfigs(Map<String, String> configs) {
        this.configs = configs;
        return this;
    }

    public List<String> getAnnotations() {
        return this.annotations;
    }

    public SparkConfiguration setAnnotations(List<String> annotations) {
        this.annotations = annotations;
        return this;
    }

    public String getNotes() {
        return this.notes;
    }

    public SparkConfiguration setNotes(String notes) {
        this.notes = notes;
        return this;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public SparkConfiguration setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    public OffsetDateTime getCreated() {
        return this.created;
    }

    public SparkConfiguration setCreated(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    public Map<String, String> getConfigMergeRule() {
        return this.configMergeRule;
    }

    public SparkConfiguration setConfigMergeRule(Map<String, String> configMergeRule) {
        this.configMergeRule = configMergeRule;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("configs", this.configs, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("annotations", this.annotations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("notes", this.notes);
        jsonWriter.writeStringField("createdBy", this.createdBy);
        jsonWriter.writeStringField("created", this.created == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.created));
        jsonWriter.writeMapField("configMergeRule", this.configMergeRule, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static SparkConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (SparkConfiguration)jsonReader.readObject(reader -> {
            SparkConfiguration deserializedSparkConfiguration = new SparkConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("configs".equals(fieldName)) {
                    Map configs;
                    deserializedSparkConfiguration.configs = configs = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSparkConfiguration.description = reader.getString();
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations;
                    deserializedSparkConfiguration.annotations = annotations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("notes".equals(fieldName)) {
                    deserializedSparkConfiguration.notes = reader.getString();
                    continue;
                }
                if ("createdBy".equals(fieldName)) {
                    deserializedSparkConfiguration.createdBy = reader.getString();
                    continue;
                }
                if ("created".equals(fieldName)) {
                    deserializedSparkConfiguration.created = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("configMergeRule".equals(fieldName)) {
                    Map configMergeRule;
                    deserializedSparkConfiguration.configMergeRule = configMergeRule = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSparkConfiguration;
        });
    }
}

