/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.SparkRequest;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class SparkBatchJobState
implements JsonSerializable<SparkBatchJobState> {
    private OffsetDateTime notStartedAt;
    private OffsetDateTime startingAt;
    private OffsetDateTime runningAt;
    private OffsetDateTime deadAt;
    private OffsetDateTime successAt;
    private OffsetDateTime terminatedAt;
    private OffsetDateTime recoveringAt;
    private String currentState;
    private SparkRequest jobCreationRequest;

    public OffsetDateTime getNotStartedAt() {
        return this.notStartedAt;
    }

    public SparkBatchJobState setNotStartedAt(OffsetDateTime notStartedAt) {
        this.notStartedAt = notStartedAt;
        return this;
    }

    public OffsetDateTime getStartingAt() {
        return this.startingAt;
    }

    public SparkBatchJobState setStartingAt(OffsetDateTime startingAt) {
        this.startingAt = startingAt;
        return this;
    }

    public OffsetDateTime getRunningAt() {
        return this.runningAt;
    }

    public SparkBatchJobState setRunningAt(OffsetDateTime runningAt) {
        this.runningAt = runningAt;
        return this;
    }

    public OffsetDateTime getDeadAt() {
        return this.deadAt;
    }

    public SparkBatchJobState setDeadAt(OffsetDateTime deadAt) {
        this.deadAt = deadAt;
        return this;
    }

    public OffsetDateTime getSuccessAt() {
        return this.successAt;
    }

    public SparkBatchJobState setSuccessAt(OffsetDateTime successAt) {
        this.successAt = successAt;
        return this;
    }

    public OffsetDateTime getTerminatedAt() {
        return this.terminatedAt;
    }

    public SparkBatchJobState setTerminatedAt(OffsetDateTime terminatedAt) {
        this.terminatedAt = terminatedAt;
        return this;
    }

    public OffsetDateTime getRecoveringAt() {
        return this.recoveringAt;
    }

    public SparkBatchJobState setRecoveringAt(OffsetDateTime recoveringAt) {
        this.recoveringAt = recoveringAt;
        return this;
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public SparkBatchJobState setCurrentState(String currentState) {
        this.currentState = currentState;
        return this;
    }

    public SparkRequest getJobCreationRequest() {
        return this.jobCreationRequest;
    }

    public SparkBatchJobState setJobCreationRequest(SparkRequest jobCreationRequest) {
        this.jobCreationRequest = jobCreationRequest;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("notStartedAt", this.notStartedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.notStartedAt));
        jsonWriter.writeStringField("startingAt", this.startingAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startingAt));
        jsonWriter.writeStringField("runningAt", this.runningAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.runningAt));
        jsonWriter.writeStringField("deadAt", this.deadAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.deadAt));
        jsonWriter.writeStringField("successAt", this.successAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.successAt));
        jsonWriter.writeStringField("killedAt", this.terminatedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.terminatedAt));
        jsonWriter.writeStringField("recoveringAt", this.recoveringAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.recoveringAt));
        jsonWriter.writeStringField("currentState", this.currentState);
        jsonWriter.writeJsonField("jobCreationRequest", (JsonSerializable)this.jobCreationRequest);
        return jsonWriter.writeEndObject();
    }

    public static SparkBatchJobState fromJson(JsonReader jsonReader) throws IOException {
        return (SparkBatchJobState)jsonReader.readObject(reader -> {
            SparkBatchJobState deserializedSparkBatchJobState = new SparkBatchJobState();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("notStartedAt".equals(fieldName)) {
                    deserializedSparkBatchJobState.notStartedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("startingAt".equals(fieldName)) {
                    deserializedSparkBatchJobState.startingAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("runningAt".equals(fieldName)) {
                    deserializedSparkBatchJobState.runningAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("deadAt".equals(fieldName)) {
                    deserializedSparkBatchJobState.deadAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("successAt".equals(fieldName)) {
                    deserializedSparkBatchJobState.successAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("killedAt".equals(fieldName)) {
                    deserializedSparkBatchJobState.terminatedAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("recoveringAt".equals(fieldName)) {
                    deserializedSparkBatchJobState.recoveringAt = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("currentState".equals(fieldName)) {
                    deserializedSparkBatchJobState.currentState = reader.getString();
                    continue;
                }
                if ("jobCreationRequest".equals(fieldName)) {
                    deserializedSparkBatchJobState.jobCreationRequest = SparkRequest.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSparkBatchJobState;
        });
    }
}

