/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CopySink;
import com.azure.analytics.synapse.artifacts.models.SnowflakeImportCopyCommand;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SnowflakeV2Sink
extends CopySink {
    private String type = "SnowflakeV2Sink";
    private Object preCopyScript;
    private SnowflakeImportCopyCommand importSettings;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getPreCopyScript() {
        return this.preCopyScript;
    }

    public SnowflakeV2Sink setPreCopyScript(Object preCopyScript) {
        this.preCopyScript = preCopyScript;
        return this;
    }

    public SnowflakeImportCopyCommand getImportSettings() {
        return this.importSettings;
    }

    public SnowflakeV2Sink setImportSettings(SnowflakeImportCopyCommand importSettings) {
        this.importSettings = importSettings;
        return this;
    }

    @Override
    public SnowflakeV2Sink setWriteBatchSize(Object writeBatchSize) {
        super.setWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public SnowflakeV2Sink setWriteBatchTimeout(Object writeBatchTimeout) {
        super.setWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public SnowflakeV2Sink setSinkRetryCount(Object sinkRetryCount) {
        super.setSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public SnowflakeV2Sink setSinkRetryWait(Object sinkRetryWait) {
        super.setSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public SnowflakeV2Sink setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getWriteBatchSize() != null) {
            jsonWriter.writeUntypedField("writeBatchSize", this.getWriteBatchSize());
        }
        if (this.getWriteBatchTimeout() != null) {
            jsonWriter.writeUntypedField("writeBatchTimeout", this.getWriteBatchTimeout());
        }
        if (this.getSinkRetryCount() != null) {
            jsonWriter.writeUntypedField("sinkRetryCount", this.getSinkRetryCount());
        }
        if (this.getSinkRetryWait() != null) {
            jsonWriter.writeUntypedField("sinkRetryWait", this.getSinkRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.preCopyScript != null) {
            jsonWriter.writeUntypedField("preCopyScript", this.preCopyScript);
        }
        jsonWriter.writeJsonField("importSettings", (JsonSerializable)this.importSettings);
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SnowflakeV2Sink fromJson(JsonReader jsonReader) throws IOException {
        return (SnowflakeV2Sink)jsonReader.readObject(reader -> {
            SnowflakeV2Sink deserializedSnowflakeV2Sink = new SnowflakeV2Sink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedSnowflakeV2Sink.setWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedSnowflakeV2Sink.setWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedSnowflakeV2Sink.setSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedSnowflakeV2Sink.setSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSnowflakeV2Sink.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSnowflakeV2Sink.type = reader.getString();
                    continue;
                }
                if ("preCopyScript".equals(fieldName)) {
                    deserializedSnowflakeV2Sink.preCopyScript = reader.readUntyped();
                    continue;
                }
                if ("importSettings".equals(fieldName)) {
                    deserializedSnowflakeV2Sink.importSettings = SnowflakeImportCopyCommand.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSnowflakeV2Sink.setAdditionalProperties(additionalProperties);
            return deserializedSnowflakeV2Sink;
        });
    }
}

