/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.analytics.synapse.artifacts.models.SnowflakeAuthenticationType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SnowflakeV2LinkedService
extends LinkedService {
    private String type = "SnowflakeV2";
    private Object accountIdentifier;
    private Object user;
    private SecretBase password;
    private Object database;
    private Object warehouse;
    private SnowflakeAuthenticationType authenticationType;
    private Object clientId;
    private SecretBase clientSecret;
    private Object tenantId;
    private Object scope;
    private Object role;
    private Object host;
    private Object schema;
    private SecretBase privateKey;
    private SecretBase privateKeyPassphrase;
    private String encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getAccountIdentifier() {
        return this.accountIdentifier;
    }

    public SnowflakeV2LinkedService setAccountIdentifier(Object accountIdentifier) {
        this.accountIdentifier = accountIdentifier;
        return this;
    }

    public Object getUser() {
        return this.user;
    }

    public SnowflakeV2LinkedService setUser(Object user) {
        this.user = user;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public SnowflakeV2LinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getDatabase() {
        return this.database;
    }

    public SnowflakeV2LinkedService setDatabase(Object database) {
        this.database = database;
        return this;
    }

    public Object getWarehouse() {
        return this.warehouse;
    }

    public SnowflakeV2LinkedService setWarehouse(Object warehouse) {
        this.warehouse = warehouse;
        return this;
    }

    public SnowflakeAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public SnowflakeV2LinkedService setAuthenticationType(SnowflakeAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getClientId() {
        return this.clientId;
    }

    public SnowflakeV2LinkedService setClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase getClientSecret() {
        return this.clientSecret;
    }

    public SnowflakeV2LinkedService setClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public Object getTenantId() {
        return this.tenantId;
    }

    public SnowflakeV2LinkedService setTenantId(Object tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public Object getScope() {
        return this.scope;
    }

    public SnowflakeV2LinkedService setScope(Object scope) {
        this.scope = scope;
        return this;
    }

    public Object getRole() {
        return this.role;
    }

    public SnowflakeV2LinkedService setRole(Object role) {
        this.role = role;
        return this;
    }

    public Object getHost() {
        return this.host;
    }

    public SnowflakeV2LinkedService setHost(Object host) {
        this.host = host;
        return this;
    }

    public Object getSchema() {
        return this.schema;
    }

    public SnowflakeV2LinkedService setSchema(Object schema) {
        this.schema = schema;
        return this;
    }

    public SecretBase getPrivateKey() {
        return this.privateKey;
    }

    public SnowflakeV2LinkedService setPrivateKey(SecretBase privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public SecretBase getPrivateKeyPassphrase() {
        return this.privateKeyPassphrase;
    }

    public SnowflakeV2LinkedService setPrivateKeyPassphrase(SecretBase privateKeyPassphrase) {
        this.privateKeyPassphrase = privateKeyPassphrase;
        return this;
    }

    public String getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public SnowflakeV2LinkedService setEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public SnowflakeV2LinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public SnowflakeV2LinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public SnowflakeV2LinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SnowflakeV2LinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public SnowflakeV2LinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.accountIdentifier != null || this.user != null || this.password != null || this.database != null || this.warehouse != null || this.authenticationType != null || this.clientId != null || this.clientSecret != null || this.tenantId != null || this.scope != null || this.role != null || this.host != null || this.schema != null || this.privateKey != null || this.privateKeyPassphrase != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("accountIdentifier", this.accountIdentifier);
            if (this.user != null) {
                jsonWriter.writeUntypedField("user", this.user);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            jsonWriter.writeUntypedField("database", this.database);
            jsonWriter.writeUntypedField("warehouse", this.warehouse);
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            if (this.clientId != null) {
                jsonWriter.writeUntypedField("clientId", this.clientId);
            }
            jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
            if (this.tenantId != null) {
                jsonWriter.writeUntypedField("tenantId", this.tenantId);
            }
            if (this.scope != null) {
                jsonWriter.writeUntypedField("scope", this.scope);
            }
            if (this.role != null) {
                jsonWriter.writeUntypedField("role", this.role);
            }
            if (this.host != null) {
                jsonWriter.writeUntypedField("host", this.host);
            }
            if (this.schema != null) {
                jsonWriter.writeUntypedField("schema", this.schema);
            }
            jsonWriter.writeJsonField("privateKey", (JsonSerializable)this.privateKey);
            jsonWriter.writeJsonField("privateKeyPassphrase", (JsonSerializable)this.privateKeyPassphrase);
            jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SnowflakeV2LinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (SnowflakeV2LinkedService)jsonReader.readObject(reader -> {
            SnowflakeV2LinkedService deserializedSnowflakeV2LinkedService = new SnowflakeV2LinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedSnowflakeV2LinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedSnowflakeV2LinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSnowflakeV2LinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSnowflakeV2LinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSnowflakeV2LinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSnowflakeV2LinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("accountIdentifier".equals(fieldName)) {
                            deserializedSnowflakeV2LinkedService.accountIdentifier = reader.readUntyped();
                            continue;
                        }
                        if ("user".equals(fieldName)) {
                            deserializedSnowflakeV2LinkedService.user = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedSnowflakeV2LinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("database".equals(fieldName)) {
                            deserializedSnowflakeV2LinkedService.database = reader.readUntyped();
                            continue;
                        }
                        if ("warehouse".equals(fieldName)) {
                            deserializedSnowflakeV2LinkedService.warehouse = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedSnowflakeV2LinkedService.authenticationType = SnowflakeAuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("clientId".equals(fieldName)) {
                            deserializedSnowflakeV2LinkedService.clientId = reader.readUntyped();
                            continue;
                        }
                        if ("clientSecret".equals(fieldName)) {
                            deserializedSnowflakeV2LinkedService.clientSecret = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("tenantId".equals(fieldName)) {
                            deserializedSnowflakeV2LinkedService.tenantId = reader.readUntyped();
                            continue;
                        }
                        if ("scope".equals(fieldName)) {
                            deserializedSnowflakeV2LinkedService.scope = reader.readUntyped();
                            continue;
                        }
                        if ("role".equals(fieldName)) {
                            deserializedSnowflakeV2LinkedService.role = reader.readUntyped();
                            continue;
                        }
                        if ("host".equals(fieldName)) {
                            deserializedSnowflakeV2LinkedService.host = reader.readUntyped();
                            continue;
                        }
                        if ("schema".equals(fieldName)) {
                            deserializedSnowflakeV2LinkedService.schema = reader.readUntyped();
                            continue;
                        }
                        if ("privateKey".equals(fieldName)) {
                            deserializedSnowflakeV2LinkedService.privateKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("privateKeyPassphrase".equals(fieldName)) {
                            deserializedSnowflakeV2LinkedService.privateKeyPassphrase = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedSnowflakeV2LinkedService.encryptedCredential = reader.getString();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSnowflakeV2LinkedService.setAdditionalProperties(additionalProperties);
            return deserializedSnowflakeV2LinkedService;
        });
    }
}

