/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.MetadataItem;
import com.azure.analytics.synapse.artifacts.models.StoreWriteSettings;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SftpWriteSettings
extends StoreWriteSettings {
    private String type = "SftpWriteSettings";
    private Object operationTimeout;
    private Object useTempFileRename;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getOperationTimeout() {
        return this.operationTimeout;
    }

    public SftpWriteSettings setOperationTimeout(Object operationTimeout) {
        this.operationTimeout = operationTimeout;
        return this;
    }

    public Object getUseTempFileRename() {
        return this.useTempFileRename;
    }

    public SftpWriteSettings setUseTempFileRename(Object useTempFileRename) {
        this.useTempFileRename = useTempFileRename;
        return this;
    }

    @Override
    public SftpWriteSettings setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public SftpWriteSettings setCopyBehavior(Object copyBehavior) {
        super.setCopyBehavior(copyBehavior);
        return this;
    }

    @Override
    public SftpWriteSettings setMetadata(List<MetadataItem> metadata) {
        super.setMetadata(metadata);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        if (this.getCopyBehavior() != null) {
            jsonWriter.writeUntypedField("copyBehavior", this.getCopyBehavior());
        }
        jsonWriter.writeArrayField("metadata", this.getMetadata(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("type", this.type);
        if (this.operationTimeout != null) {
            jsonWriter.writeUntypedField("operationTimeout", this.operationTimeout);
        }
        if (this.useTempFileRename != null) {
            jsonWriter.writeUntypedField("useTempFileRename", this.useTempFileRename);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SftpWriteSettings fromJson(JsonReader jsonReader) throws IOException {
        return (SftpWriteSettings)jsonReader.readObject(reader -> {
            SftpWriteSettings deserializedSftpWriteSettings = new SftpWriteSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSftpWriteSettings.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("copyBehavior".equals(fieldName)) {
                    deserializedSftpWriteSettings.setCopyBehavior(reader.readUntyped());
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    List metadata = reader.readArray(reader1 -> MetadataItem.fromJson(reader1));
                    deserializedSftpWriteSettings.setMetadata(metadata);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSftpWriteSettings.type = reader.getString();
                    continue;
                }
                if ("operationTimeout".equals(fieldName)) {
                    deserializedSftpWriteSettings.operationTimeout = reader.readUntyped();
                    continue;
                }
                if ("useTempFileRename".equals(fieldName)) {
                    deserializedSftpWriteSettings.useTempFileRename = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSftpWriteSettings.setAdditionalProperties(additionalProperties);
            return deserializedSftpWriteSettings;
        });
    }
}

