/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ExpressionV2;
import com.azure.analytics.synapse.artifacts.models.TabularSource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ServiceNowV2Source
extends TabularSource {
    private String type = "ServiceNowV2Source";
    private ExpressionV2 expression;
    private Object pageSize;

    @Override
    public String getType() {
        return this.type;
    }

    public ExpressionV2 getExpression() {
        return this.expression;
    }

    public ServiceNowV2Source setExpression(ExpressionV2 expression) {
        this.expression = expression;
        return this;
    }

    public Object getPageSize() {
        return this.pageSize;
    }

    public ServiceNowV2Source setPageSize(Object pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public ServiceNowV2Source setQueryTimeout(Object queryTimeout) {
        super.setQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public ServiceNowV2Source setAdditionalColumns(Object additionalColumns) {
        super.setAdditionalColumns(additionalColumns);
        return this;
    }

    @Override
    public ServiceNowV2Source setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public ServiceNowV2Source setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public ServiceNowV2Source setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        if (this.getQueryTimeout() != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.getQueryTimeout());
        }
        if (this.getAdditionalColumns() != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.getAdditionalColumns());
        }
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("expression", (JsonSerializable)this.expression);
        if (this.pageSize != null) {
            jsonWriter.writeUntypedField("pageSize", this.pageSize);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ServiceNowV2Source fromJson(JsonReader jsonReader) throws IOException {
        return (ServiceNowV2Source)jsonReader.readObject(reader -> {
            ServiceNowV2Source deserializedServiceNowV2Source = new ServiceNowV2Source();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedServiceNowV2Source.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedServiceNowV2Source.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedServiceNowV2Source.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedServiceNowV2Source.setQueryTimeout(reader.readUntyped());
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedServiceNowV2Source.setAdditionalColumns(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedServiceNowV2Source.type = reader.getString();
                    continue;
                }
                if ("expression".equals(fieldName)) {
                    deserializedServiceNowV2Source.expression = ExpressionV2.fromJson(reader);
                    continue;
                }
                if ("pageSize".equals(fieldName)) {
                    deserializedServiceNowV2Source.pageSize = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedServiceNowV2Source.setAdditionalProperties(additionalProperties);
            return deserializedServiceNowV2Source;
        });
    }
}

