/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.analytics.synapse.artifacts.models.ServiceNowV2AuthenticationType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ServiceNowV2LinkedService
extends LinkedService {
    private String type = "ServiceNowV2";
    private Object endpoint;
    private ServiceNowV2AuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private Object clientId;
    private SecretBase clientSecret;
    private Object grantType;
    private String encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getEndpoint() {
        return this.endpoint;
    }

    public ServiceNowV2LinkedService setEndpoint(Object endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public ServiceNowV2AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public ServiceNowV2LinkedService setAuthenticationType(ServiceNowV2AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getUsername() {
        return this.username;
    }

    public ServiceNowV2LinkedService setUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public ServiceNowV2LinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getClientId() {
        return this.clientId;
    }

    public ServiceNowV2LinkedService setClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase getClientSecret() {
        return this.clientSecret;
    }

    public ServiceNowV2LinkedService setClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public Object getGrantType() {
        return this.grantType;
    }

    public ServiceNowV2LinkedService setGrantType(Object grantType) {
        this.grantType = grantType;
        return this;
    }

    public String getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public ServiceNowV2LinkedService setEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public ServiceNowV2LinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public ServiceNowV2LinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public ServiceNowV2LinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public ServiceNowV2LinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public ServiceNowV2LinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.endpoint != null || this.authenticationType != null || this.username != null || this.password != null || this.clientId != null || this.clientSecret != null || this.grantType != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("endpoint", this.endpoint);
            jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
            if (this.username != null) {
                jsonWriter.writeUntypedField("username", this.username);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.clientId != null) {
                jsonWriter.writeUntypedField("clientId", this.clientId);
            }
            jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
            if (this.grantType != null) {
                jsonWriter.writeUntypedField("grantType", this.grantType);
            }
            jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ServiceNowV2LinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (ServiceNowV2LinkedService)jsonReader.readObject(reader -> {
            ServiceNowV2LinkedService deserializedServiceNowV2LinkedService = new ServiceNowV2LinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedServiceNowV2LinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedServiceNowV2LinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedServiceNowV2LinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedServiceNowV2LinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedServiceNowV2LinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedServiceNowV2LinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("endpoint".equals(fieldName)) {
                            deserializedServiceNowV2LinkedService.endpoint = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedServiceNowV2LinkedService.authenticationType = ServiceNowV2AuthenticationType.fromString(reader.getString());
                            continue;
                        }
                        if ("username".equals(fieldName)) {
                            deserializedServiceNowV2LinkedService.username = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedServiceNowV2LinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("clientId".equals(fieldName)) {
                            deserializedServiceNowV2LinkedService.clientId = reader.readUntyped();
                            continue;
                        }
                        if ("clientSecret".equals(fieldName)) {
                            deserializedServiceNowV2LinkedService.clientSecret = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("grantType".equals(fieldName)) {
                            deserializedServiceNowV2LinkedService.grantType = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedServiceNowV2LinkedService.encryptedCredential = reader.getString();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedServiceNowV2LinkedService.setAdditionalProperties(additionalProperties);
            return deserializedServiceNowV2LinkedService;
        });
    }
}

