/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntime;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeType;
import com.azure.analytics.synapse.artifacts.models.LinkedIntegrationRuntimeType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class SelfHostedIntegrationRuntime
extends IntegrationRuntime {
    private IntegrationRuntimeType type = IntegrationRuntimeType.SELF_HOSTED;
    private LinkedIntegrationRuntimeType linkedInfo;

    @Override
    public IntegrationRuntimeType getType() {
        return this.type;
    }

    public LinkedIntegrationRuntimeType getLinkedInfo() {
        return this.linkedInfo;
    }

    public SelfHostedIntegrationRuntime setLinkedInfo(LinkedIntegrationRuntimeType linkedInfo) {
        this.linkedInfo = linkedInfo;
        return this;
    }

    @Override
    public SelfHostedIntegrationRuntime setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        if (this.linkedInfo != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeJsonField("linkedInfo", (JsonSerializable)this.linkedInfo);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SelfHostedIntegrationRuntime fromJson(JsonReader jsonReader) throws IOException {
        return (SelfHostedIntegrationRuntime)jsonReader.readObject(reader -> {
            SelfHostedIntegrationRuntime deserializedSelfHostedIntegrationRuntime = new SelfHostedIntegrationRuntime();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntime.setDescription(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSelfHostedIntegrationRuntime.type = IntegrationRuntimeType.fromString(reader.getString());
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("linkedInfo".equals(fieldName)) {
                            deserializedSelfHostedIntegrationRuntime.linkedInfo = LinkedIntegrationRuntimeType.fromJson(reader);
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSelfHostedIntegrationRuntime.setAdditionalProperties(additionalProperties);
            return deserializedSelfHostedIntegrationRuntime;
        });
    }
}

