/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.ActivityDependency;
import com.azure.analytics.synapse.artifacts.models.ActivityOnInactiveMarkAs;
import com.azure.analytics.synapse.artifacts.models.ActivityPolicy;
import com.azure.analytics.synapse.artifacts.models.ActivityState;
import com.azure.analytics.synapse.artifacts.models.ExecutionActivity;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.ScriptActivityScriptBlock;
import com.azure.analytics.synapse.artifacts.models.ScriptActivityTypePropertiesLogSettings;
import com.azure.analytics.synapse.artifacts.models.UserProperty;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ScriptActivity
extends ExecutionActivity {
    private String type = "Script";
    private Object scriptBlockExecutionTimeout;
    private List<ScriptActivityScriptBlock> scripts;
    private ScriptActivityTypePropertiesLogSettings logSettings;
    private Object returnMultistatementResult;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getScriptBlockExecutionTimeout() {
        return this.scriptBlockExecutionTimeout;
    }

    public ScriptActivity setScriptBlockExecutionTimeout(Object scriptBlockExecutionTimeout) {
        this.scriptBlockExecutionTimeout = scriptBlockExecutionTimeout;
        return this;
    }

    public List<ScriptActivityScriptBlock> getScripts() {
        return this.scripts;
    }

    public ScriptActivity setScripts(List<ScriptActivityScriptBlock> scripts) {
        this.scripts = scripts;
        return this;
    }

    public ScriptActivityTypePropertiesLogSettings getLogSettings() {
        return this.logSettings;
    }

    public ScriptActivity setLogSettings(ScriptActivityTypePropertiesLogSettings logSettings) {
        this.logSettings = logSettings;
        return this;
    }

    public Object getReturnMultistatementResult() {
        return this.returnMultistatementResult;
    }

    public ScriptActivity setReturnMultistatementResult(Object returnMultistatementResult) {
        this.returnMultistatementResult = returnMultistatementResult;
        return this;
    }

    @Override
    public ScriptActivity setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public ScriptActivity setPolicy(ActivityPolicy policy) {
        super.setPolicy(policy);
        return this;
    }

    @Override
    public ScriptActivity setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public ScriptActivity setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public ScriptActivity setState(ActivityState state) {
        super.setState(state);
        return this;
    }

    @Override
    public ScriptActivity setOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.setOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public ScriptActivity setDependsOn(List<ActivityDependency> dependsOn) {
        super.setDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public ScriptActivity setUserProperties(List<UserProperty> userProperties) {
        super.setUserProperties((List)userProperties);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.getName());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeStringField("state", this.getState() == null ? null : this.getState().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.getOnInactiveMarkAs() == null ? null : this.getOnInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.getDependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.getUserProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.getPolicy());
        jsonWriter.writeStringField("type", this.type);
        if (this.scriptBlockExecutionTimeout != null || this.scripts != null || this.logSettings != null || this.returnMultistatementResult != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.scriptBlockExecutionTimeout != null) {
                jsonWriter.writeUntypedField("scriptBlockExecutionTimeout", this.scriptBlockExecutionTimeout);
            }
            jsonWriter.writeArrayField("scripts", this.scripts, (writer, element) -> writer.writeJson((JsonSerializable)element));
            jsonWriter.writeJsonField("logSettings", (JsonSerializable)this.logSettings);
            if (this.returnMultistatementResult != null) {
                jsonWriter.writeUntypedField("returnMultistatementResult", this.returnMultistatementResult);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ScriptActivity fromJson(JsonReader jsonReader) throws IOException {
        return (ScriptActivity)jsonReader.readObject(reader -> {
            ScriptActivity deserializedScriptActivity = new ScriptActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedScriptActivity.setName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedScriptActivity.setDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedScriptActivity.setState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedScriptActivity.setOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedScriptActivity.setDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedScriptActivity.setUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedScriptActivity.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedScriptActivity.setPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedScriptActivity.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("scriptBlockExecutionTimeout".equals(fieldName)) {
                            deserializedScriptActivity.scriptBlockExecutionTimeout = reader.readUntyped();
                            continue;
                        }
                        if ("scripts".equals(fieldName)) {
                            List scripts;
                            deserializedScriptActivity.scripts = scripts = reader.readArray(reader1 -> ScriptActivityScriptBlock.fromJson(reader1));
                            continue;
                        }
                        if ("logSettings".equals(fieldName)) {
                            deserializedScriptActivity.logSettings = ScriptActivityTypePropertiesLogSettings.fromJson(reader);
                            continue;
                        }
                        if ("returnMultistatementResult".equals(fieldName)) {
                            deserializedScriptActivity.returnMultistatementResult = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedScriptActivity.setAdditionalProperties(additionalProperties);
            return deserializedScriptActivity;
        });
    }
}

