/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.TabularSource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SapOpenHubSource
extends TabularSource {
    private String type = "SapOpenHubSource";
    private Object excludeLastRequest;
    private Object baseRequestId;
    private Object customRfcReadTableFunctionModule;
    private Object sapDataColumnDelimiter;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getExcludeLastRequest() {
        return this.excludeLastRequest;
    }

    public SapOpenHubSource setExcludeLastRequest(Object excludeLastRequest) {
        this.excludeLastRequest = excludeLastRequest;
        return this;
    }

    public Object getBaseRequestId() {
        return this.baseRequestId;
    }

    public SapOpenHubSource setBaseRequestId(Object baseRequestId) {
        this.baseRequestId = baseRequestId;
        return this;
    }

    public Object getCustomRfcReadTableFunctionModule() {
        return this.customRfcReadTableFunctionModule;
    }

    public SapOpenHubSource setCustomRfcReadTableFunctionModule(Object customRfcReadTableFunctionModule) {
        this.customRfcReadTableFunctionModule = customRfcReadTableFunctionModule;
        return this;
    }

    public Object getSapDataColumnDelimiter() {
        return this.sapDataColumnDelimiter;
    }

    public SapOpenHubSource setSapDataColumnDelimiter(Object sapDataColumnDelimiter) {
        this.sapDataColumnDelimiter = sapDataColumnDelimiter;
        return this;
    }

    @Override
    public SapOpenHubSource setQueryTimeout(Object queryTimeout) {
        super.setQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public SapOpenHubSource setAdditionalColumns(Object additionalColumns) {
        super.setAdditionalColumns(additionalColumns);
        return this;
    }

    @Override
    public SapOpenHubSource setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public SapOpenHubSource setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public SapOpenHubSource setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        if (this.getQueryTimeout() != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.getQueryTimeout());
        }
        if (this.getAdditionalColumns() != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.getAdditionalColumns());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.excludeLastRequest != null) {
            jsonWriter.writeUntypedField("excludeLastRequest", this.excludeLastRequest);
        }
        if (this.baseRequestId != null) {
            jsonWriter.writeUntypedField("baseRequestId", this.baseRequestId);
        }
        if (this.customRfcReadTableFunctionModule != null) {
            jsonWriter.writeUntypedField("customRfcReadTableFunctionModule", this.customRfcReadTableFunctionModule);
        }
        if (this.sapDataColumnDelimiter != null) {
            jsonWriter.writeUntypedField("sapDataColumnDelimiter", this.sapDataColumnDelimiter);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SapOpenHubSource fromJson(JsonReader jsonReader) throws IOException {
        return (SapOpenHubSource)jsonReader.readObject(reader -> {
            SapOpenHubSource deserializedSapOpenHubSource = new SapOpenHubSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedSapOpenHubSource.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedSapOpenHubSource.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSapOpenHubSource.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedSapOpenHubSource.setQueryTimeout(reader.readUntyped());
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedSapOpenHubSource.setAdditionalColumns(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSapOpenHubSource.type = reader.getString();
                    continue;
                }
                if ("excludeLastRequest".equals(fieldName)) {
                    deserializedSapOpenHubSource.excludeLastRequest = reader.readUntyped();
                    continue;
                }
                if ("baseRequestId".equals(fieldName)) {
                    deserializedSapOpenHubSource.baseRequestId = reader.readUntyped();
                    continue;
                }
                if ("customRfcReadTableFunctionModule".equals(fieldName)) {
                    deserializedSapOpenHubSource.customRfcReadTableFunctionModule = reader.readUntyped();
                    continue;
                }
                if ("sapDataColumnDelimiter".equals(fieldName)) {
                    deserializedSapOpenHubSource.sapDataColumnDelimiter = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSapOpenHubSource.setAdditionalProperties(additionalProperties);
            return deserializedSapOpenHubSource;
        });
    }
}

