/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Dataset;
import com.azure.analytics.synapse.artifacts.models.DatasetFolder;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SapEccResourceDataset
extends Dataset {
    private String type = "SapEccResource";
    private Object path;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getPath() {
        return this.path;
    }

    public SapEccResourceDataset setPath(Object path) {
        this.path = path;
        return this;
    }

    @Override
    public SapEccResourceDataset setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SapEccResourceDataset setStructure(Object structure) {
        super.setStructure(structure);
        return this;
    }

    @Override
    public SapEccResourceDataset setSchema(Object schema) {
        super.setSchema(schema);
        return this;
    }

    @Override
    public SapEccResourceDataset setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public SapEccResourceDataset setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public SapEccResourceDataset setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public SapEccResourceDataset setFolder(DatasetFolder folder) {
        super.setFolder(folder);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeStringField("description", this.getDescription());
        if (this.getStructure() != null) {
            jsonWriter.writeUntypedField("structure", this.getStructure());
        }
        if (this.getSchema() != null) {
            jsonWriter.writeUntypedField("schema", this.getSchema());
        }
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.getFolder());
        jsonWriter.writeStringField("type", this.type);
        if (this.path != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("path", this.path);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SapEccResourceDataset fromJson(JsonReader jsonReader) throws IOException {
        return (SapEccResourceDataset)jsonReader.readObject(reader -> {
            SapEccResourceDataset deserializedSapEccResourceDataset = new SapEccResourceDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedSapEccResourceDataset.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSapEccResourceDataset.setDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedSapEccResourceDataset.setStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedSapEccResourceDataset.setSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSapEccResourceDataset.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSapEccResourceDataset.setAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedSapEccResourceDataset.setFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSapEccResourceDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("path".equals(fieldName)) {
                            deserializedSapEccResourceDataset.path = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSapEccResourceDataset.setAdditionalProperties(additionalProperties);
            return deserializedSapEccResourceDataset;
        });
    }
}

