/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SapBWLinkedService
extends LinkedService {
    private String type = "SapBW";
    private Object server;
    private Object systemNumber;
    private Object clientId;
    private Object userName;
    private SecretBase password;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getServer() {
        return this.server;
    }

    public SapBWLinkedService setServer(Object server) {
        this.server = server;
        return this;
    }

    public Object getSystemNumber() {
        return this.systemNumber;
    }

    public SapBWLinkedService setSystemNumber(Object systemNumber) {
        this.systemNumber = systemNumber;
        return this;
    }

    public Object getClientId() {
        return this.clientId;
    }

    public SapBWLinkedService setClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public Object getUserName() {
        return this.userName;
    }

    public SapBWLinkedService setUserName(Object userName) {
        this.userName = userName;
        return this;
    }

    public SecretBase getPassword() {
        return this.password;
    }

    public SapBWLinkedService setPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public SapBWLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public SapBWLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public SapBWLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public SapBWLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SapBWLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public SapBWLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.server != null || this.systemNumber != null || this.clientId != null || this.userName != null || this.password != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("server", this.server);
            jsonWriter.writeUntypedField("systemNumber", this.systemNumber);
            jsonWriter.writeUntypedField("clientId", this.clientId);
            if (this.userName != null) {
                jsonWriter.writeUntypedField("userName", this.userName);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SapBWLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (SapBWLinkedService)jsonReader.readObject(reader -> {
            SapBWLinkedService deserializedSapBWLinkedService = new SapBWLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedSapBWLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedSapBWLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSapBWLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSapBWLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSapBWLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSapBWLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("server".equals(fieldName)) {
                            deserializedSapBWLinkedService.server = reader.readUntyped();
                            continue;
                        }
                        if ("systemNumber".equals(fieldName)) {
                            deserializedSapBWLinkedService.systemNumber = reader.readUntyped();
                            continue;
                        }
                        if ("clientId".equals(fieldName)) {
                            deserializedSapBWLinkedService.clientId = reader.readUntyped();
                            continue;
                        }
                        if ("userName".equals(fieldName)) {
                            deserializedSapBWLinkedService.userName = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedSapBWLinkedService.password = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedSapBWLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSapBWLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedSapBWLinkedService;
        });
    }
}

