/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.TabularSource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SalesforceV2Source
extends TabularSource {
    private String type = "SalesforceV2Source";
    private Object soqlQuery;
    private Object query;
    private Object includeDeletedObjects;
    private Object pageSize;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getSoqlQuery() {
        return this.soqlQuery;
    }

    public SalesforceV2Source setSoqlQuery(Object soqlQuery) {
        this.soqlQuery = soqlQuery;
        return this;
    }

    public Object getQuery() {
        return this.query;
    }

    public SalesforceV2Source setQuery(Object query) {
        this.query = query;
        return this;
    }

    public Object getIncludeDeletedObjects() {
        return this.includeDeletedObjects;
    }

    public SalesforceV2Source setIncludeDeletedObjects(Object includeDeletedObjects) {
        this.includeDeletedObjects = includeDeletedObjects;
        return this;
    }

    public Object getPageSize() {
        return this.pageSize;
    }

    public SalesforceV2Source setPageSize(Object pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public SalesforceV2Source setQueryTimeout(Object queryTimeout) {
        super.setQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public SalesforceV2Source setAdditionalColumns(Object additionalColumns) {
        super.setAdditionalColumns(additionalColumns);
        return this;
    }

    @Override
    public SalesforceV2Source setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public SalesforceV2Source setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public SalesforceV2Source setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        if (this.getQueryTimeout() != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.getQueryTimeout());
        }
        if (this.getAdditionalColumns() != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.getAdditionalColumns());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.soqlQuery != null) {
            jsonWriter.writeUntypedField("SOQLQuery", this.soqlQuery);
        }
        if (this.query != null) {
            jsonWriter.writeUntypedField("query", this.query);
        }
        if (this.includeDeletedObjects != null) {
            jsonWriter.writeUntypedField("includeDeletedObjects", this.includeDeletedObjects);
        }
        if (this.pageSize != null) {
            jsonWriter.writeUntypedField("pageSize", this.pageSize);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SalesforceV2Source fromJson(JsonReader jsonReader) throws IOException {
        return (SalesforceV2Source)jsonReader.readObject(reader -> {
            SalesforceV2Source deserializedSalesforceV2Source = new SalesforceV2Source();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedSalesforceV2Source.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedSalesforceV2Source.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSalesforceV2Source.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedSalesforceV2Source.setQueryTimeout(reader.readUntyped());
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedSalesforceV2Source.setAdditionalColumns(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSalesforceV2Source.type = reader.getString();
                    continue;
                }
                if ("SOQLQuery".equals(fieldName)) {
                    deserializedSalesforceV2Source.soqlQuery = reader.readUntyped();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedSalesforceV2Source.query = reader.readUntyped();
                    continue;
                }
                if ("includeDeletedObjects".equals(fieldName)) {
                    deserializedSalesforceV2Source.includeDeletedObjects = reader.readUntyped();
                    continue;
                }
                if ("pageSize".equals(fieldName)) {
                    deserializedSalesforceV2Source.pageSize = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSalesforceV2Source.setAdditionalProperties(additionalProperties);
            return deserializedSalesforceV2Source;
        });
    }
}

