/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SalesforceServiceCloudV2LinkedService
extends LinkedService {
    private String type = "SalesforceServiceCloudV2";
    private Object environmentUrl;
    private Object authenticationType;
    private Object clientId;
    private SecretBase clientSecret;
    private Object apiVersion;
    private String encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getEnvironmentUrl() {
        return this.environmentUrl;
    }

    public SalesforceServiceCloudV2LinkedService setEnvironmentUrl(Object environmentUrl) {
        this.environmentUrl = environmentUrl;
        return this;
    }

    public Object getAuthenticationType() {
        return this.authenticationType;
    }

    public SalesforceServiceCloudV2LinkedService setAuthenticationType(Object authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object getClientId() {
        return this.clientId;
    }

    public SalesforceServiceCloudV2LinkedService setClientId(Object clientId) {
        this.clientId = clientId;
        return this;
    }

    public SecretBase getClientSecret() {
        return this.clientSecret;
    }

    public SalesforceServiceCloudV2LinkedService setClientSecret(SecretBase clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public Object getApiVersion() {
        return this.apiVersion;
    }

    public SalesforceServiceCloudV2LinkedService setApiVersion(Object apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public String getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public SalesforceServiceCloudV2LinkedService setEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public SalesforceServiceCloudV2LinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public SalesforceServiceCloudV2LinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public SalesforceServiceCloudV2LinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public SalesforceServiceCloudV2LinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public SalesforceServiceCloudV2LinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.environmentUrl != null || this.authenticationType != null || this.clientId != null || this.clientSecret != null || this.apiVersion != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.environmentUrl != null) {
                jsonWriter.writeUntypedField("environmentUrl", this.environmentUrl);
            }
            if (this.authenticationType != null) {
                jsonWriter.writeUntypedField("authenticationType", this.authenticationType);
            }
            if (this.clientId != null) {
                jsonWriter.writeUntypedField("clientId", this.clientId);
            }
            jsonWriter.writeJsonField("clientSecret", (JsonSerializable)this.clientSecret);
            if (this.apiVersion != null) {
                jsonWriter.writeUntypedField("apiVersion", this.apiVersion);
            }
            jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SalesforceServiceCloudV2LinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (SalesforceServiceCloudV2LinkedService)jsonReader.readObject(reader -> {
            SalesforceServiceCloudV2LinkedService deserializedSalesforceServiceCloudV2LinkedService = new SalesforceServiceCloudV2LinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2LinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2LinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2LinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedSalesforceServiceCloudV2LinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedSalesforceServiceCloudV2LinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSalesforceServiceCloudV2LinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("environmentUrl".equals(fieldName)) {
                            deserializedSalesforceServiceCloudV2LinkedService.environmentUrl = reader.readUntyped();
                            continue;
                        }
                        if ("authenticationType".equals(fieldName)) {
                            deserializedSalesforceServiceCloudV2LinkedService.authenticationType = reader.readUntyped();
                            continue;
                        }
                        if ("clientId".equals(fieldName)) {
                            deserializedSalesforceServiceCloudV2LinkedService.clientId = reader.readUntyped();
                            continue;
                        }
                        if ("clientSecret".equals(fieldName)) {
                            deserializedSalesforceServiceCloudV2LinkedService.clientSecret = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("apiVersion".equals(fieldName)) {
                            deserializedSalesforceServiceCloudV2LinkedService.apiVersion = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedSalesforceServiceCloudV2LinkedService.encryptedCredential = reader.getString();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSalesforceServiceCloudV2LinkedService.setAdditionalProperties(additionalProperties);
            return deserializedSalesforceServiceCloudV2LinkedService;
        });
    }
}

