/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.RunQueryFilter;
import com.azure.analytics.synapse.artifacts.models.RunQueryOrderBy;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public final class RunFilterParameters
implements JsonSerializable<RunFilterParameters> {
    private String continuationToken;
    private OffsetDateTime lastUpdatedAfter;
    private OffsetDateTime lastUpdatedBefore;
    private List<RunQueryFilter> filters;
    private List<RunQueryOrderBy> orderBy;

    public String getContinuationToken() {
        return this.continuationToken;
    }

    public RunFilterParameters setContinuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
        return this;
    }

    public OffsetDateTime getLastUpdatedAfter() {
        return this.lastUpdatedAfter;
    }

    public RunFilterParameters setLastUpdatedAfter(OffsetDateTime lastUpdatedAfter) {
        this.lastUpdatedAfter = lastUpdatedAfter;
        return this;
    }

    public OffsetDateTime getLastUpdatedBefore() {
        return this.lastUpdatedBefore;
    }

    public RunFilterParameters setLastUpdatedBefore(OffsetDateTime lastUpdatedBefore) {
        this.lastUpdatedBefore = lastUpdatedBefore;
        return this;
    }

    public List<RunQueryFilter> getFilters() {
        return this.filters;
    }

    public RunFilterParameters setFilters(List<RunQueryFilter> filters) {
        this.filters = filters;
        return this;
    }

    public List<RunQueryOrderBy> getOrderBy() {
        return this.orderBy;
    }

    public RunFilterParameters setOrderBy(List<RunQueryOrderBy> orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("lastUpdatedAfter", this.lastUpdatedAfter == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedAfter));
        jsonWriter.writeStringField("lastUpdatedBefore", this.lastUpdatedBefore == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedBefore));
        jsonWriter.writeStringField("continuationToken", this.continuationToken);
        jsonWriter.writeArrayField("filters", this.filters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("orderBy", this.orderBy, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RunFilterParameters fromJson(JsonReader jsonReader) throws IOException {
        return (RunFilterParameters)jsonReader.readObject(reader -> {
            RunFilterParameters deserializedRunFilterParameters = new RunFilterParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("lastUpdatedAfter".equals(fieldName)) {
                    deserializedRunFilterParameters.lastUpdatedAfter = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdatedBefore".equals(fieldName)) {
                    deserializedRunFilterParameters.lastUpdatedBefore = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("continuationToken".equals(fieldName)) {
                    deserializedRunFilterParameters.continuationToken = reader.getString();
                    continue;
                }
                if ("filters".equals(fieldName)) {
                    List filters;
                    deserializedRunFilterParameters.filters = filters = reader.readArray(reader1 -> RunQueryFilter.fromJson(reader1));
                    continue;
                }
                if ("orderBy".equals(fieldName)) {
                    List orderBy;
                    deserializedRunFilterParameters.orderBy = orderBy = reader.readArray(reader1 -> RunQueryOrderBy.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRunFilterParameters;
        });
    }
}

