/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CopySource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class RestSource
extends CopySource {
    private String type = "RestSource";
    private Object requestMethod;
    private Object requestBody;
    private Object additionalHeaders;
    private Object paginationRules;
    private Object httpRequestTimeout;
    private Object requestInterval;
    private Object additionalColumns;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getRequestMethod() {
        return this.requestMethod;
    }

    public RestSource setRequestMethod(Object requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }

    public Object getRequestBody() {
        return this.requestBody;
    }

    public RestSource setRequestBody(Object requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public Object getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public RestSource setAdditionalHeaders(Object additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
        return this;
    }

    public Object getPaginationRules() {
        return this.paginationRules;
    }

    public RestSource setPaginationRules(Object paginationRules) {
        this.paginationRules = paginationRules;
        return this;
    }

    public Object getHttpRequestTimeout() {
        return this.httpRequestTimeout;
    }

    public RestSource setHttpRequestTimeout(Object httpRequestTimeout) {
        this.httpRequestTimeout = httpRequestTimeout;
        return this;
    }

    public Object getRequestInterval() {
        return this.requestInterval;
    }

    public RestSource setRequestInterval(Object requestInterval) {
        this.requestInterval = requestInterval;
        return this;
    }

    public Object getAdditionalColumns() {
        return this.additionalColumns;
    }

    public RestSource setAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    @Override
    public RestSource setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public RestSource setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public RestSource setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.requestMethod != null) {
            jsonWriter.writeUntypedField("requestMethod", this.requestMethod);
        }
        if (this.requestBody != null) {
            jsonWriter.writeUntypedField("requestBody", this.requestBody);
        }
        if (this.additionalHeaders != null) {
            jsonWriter.writeUntypedField("additionalHeaders", this.additionalHeaders);
        }
        if (this.paginationRules != null) {
            jsonWriter.writeUntypedField("paginationRules", this.paginationRules);
        }
        if (this.httpRequestTimeout != null) {
            jsonWriter.writeUntypedField("httpRequestTimeout", this.httpRequestTimeout);
        }
        if (this.requestInterval != null) {
            jsonWriter.writeUntypedField("requestInterval", this.requestInterval);
        }
        if (this.additionalColumns != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static RestSource fromJson(JsonReader jsonReader) throws IOException {
        return (RestSource)jsonReader.readObject(reader -> {
            RestSource deserializedRestSource = new RestSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedRestSource.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedRestSource.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedRestSource.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRestSource.type = reader.getString();
                    continue;
                }
                if ("requestMethod".equals(fieldName)) {
                    deserializedRestSource.requestMethod = reader.readUntyped();
                    continue;
                }
                if ("requestBody".equals(fieldName)) {
                    deserializedRestSource.requestBody = reader.readUntyped();
                    continue;
                }
                if ("additionalHeaders".equals(fieldName)) {
                    deserializedRestSource.additionalHeaders = reader.readUntyped();
                    continue;
                }
                if ("paginationRules".equals(fieldName)) {
                    deserializedRestSource.paginationRules = reader.readUntyped();
                    continue;
                }
                if ("httpRequestTimeout".equals(fieldName)) {
                    deserializedRestSource.httpRequestTimeout = reader.readUntyped();
                    continue;
                }
                if ("requestInterval".equals(fieldName)) {
                    deserializedRestSource.requestInterval = reader.readUntyped();
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedRestSource.additionalColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedRestSource.setAdditionalProperties(additionalProperties);
            return deserializedRestSource;
        });
    }
}

