/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.Dataset;
import com.azure.analytics.synapse.artifacts.models.DatasetFolder;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceReference;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RestResourceDataset
extends Dataset {
    private String type = "RestResource";
    private Object relativeUrl;
    private Object requestMethod;
    private Object requestBody;
    private Object additionalHeaders;
    private Object paginationRules;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getRelativeUrl() {
        return this.relativeUrl;
    }

    public RestResourceDataset setRelativeUrl(Object relativeUrl) {
        this.relativeUrl = relativeUrl;
        return this;
    }

    public Object getRequestMethod() {
        return this.requestMethod;
    }

    public RestResourceDataset setRequestMethod(Object requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }

    public Object getRequestBody() {
        return this.requestBody;
    }

    public RestResourceDataset setRequestBody(Object requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public Object getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public RestResourceDataset setAdditionalHeaders(Object additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
        return this;
    }

    public Object getPaginationRules() {
        return this.paginationRules;
    }

    public RestResourceDataset setPaginationRules(Object paginationRules) {
        this.paginationRules = paginationRules;
        return this;
    }

    @Override
    public RestResourceDataset setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public RestResourceDataset setStructure(Object structure) {
        super.setStructure(structure);
        return this;
    }

    @Override
    public RestResourceDataset setSchema(Object schema) {
        super.setSchema(schema);
        return this;
    }

    @Override
    public RestResourceDataset setLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.setLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public RestResourceDataset setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public RestResourceDataset setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public RestResourceDataset setFolder(DatasetFolder folder) {
        super.setFolder(folder);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.getLinkedServiceName());
        jsonWriter.writeStringField("description", this.getDescription());
        if (this.getStructure() != null) {
            jsonWriter.writeUntypedField("structure", this.getStructure());
        }
        if (this.getSchema() != null) {
            jsonWriter.writeUntypedField("schema", this.getSchema());
        }
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.getFolder());
        jsonWriter.writeStringField("type", this.type);
        if (this.relativeUrl != null || this.requestMethod != null || this.requestBody != null || this.additionalHeaders != null || this.paginationRules != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.relativeUrl != null) {
                jsonWriter.writeUntypedField("relativeUrl", this.relativeUrl);
            }
            if (this.requestMethod != null) {
                jsonWriter.writeUntypedField("requestMethod", this.requestMethod);
            }
            if (this.requestBody != null) {
                jsonWriter.writeUntypedField("requestBody", this.requestBody);
            }
            if (this.additionalHeaders != null) {
                jsonWriter.writeUntypedField("additionalHeaders", this.additionalHeaders);
            }
            if (this.paginationRules != null) {
                jsonWriter.writeUntypedField("paginationRules", this.paginationRules);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static RestResourceDataset fromJson(JsonReader jsonReader) throws IOException {
        return (RestResourceDataset)jsonReader.readObject(reader -> {
            RestResourceDataset deserializedRestResourceDataset = new RestResourceDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedRestResourceDataset.setLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedRestResourceDataset.setDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedRestResourceDataset.setStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedRestResourceDataset.setSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedRestResourceDataset.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedRestResourceDataset.setAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedRestResourceDataset.setFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRestResourceDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("relativeUrl".equals(fieldName)) {
                            deserializedRestResourceDataset.relativeUrl = reader.readUntyped();
                            continue;
                        }
                        if ("requestMethod".equals(fieldName)) {
                            deserializedRestResourceDataset.requestMethod = reader.readUntyped();
                            continue;
                        }
                        if ("requestBody".equals(fieldName)) {
                            deserializedRestResourceDataset.requestBody = reader.readUntyped();
                            continue;
                        }
                        if ("additionalHeaders".equals(fieldName)) {
                            deserializedRestResourceDataset.additionalHeaders = reader.readUntyped();
                            continue;
                        }
                        if ("paginationRules".equals(fieldName)) {
                            deserializedRestResourceDataset.paginationRules = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedRestResourceDataset.setAdditionalProperties(additionalProperties);
            return deserializedRestResourceDataset;
        });
    }
}

