/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class RerunTumblingWindowTriggerActionParameters
implements JsonSerializable<RerunTumblingWindowTriggerActionParameters> {
    private OffsetDateTime startTime;
    private OffsetDateTime endTime;
    private int maxConcurrency;

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public RerunTumblingWindowTriggerActionParameters setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime getEndTime() {
        return this.endTime;
    }

    public RerunTumblingWindowTriggerActionParameters setEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public RerunTumblingWindowTriggerActionParameters setMaxConcurrency(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("startTime", this.startTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.startTime));
        jsonWriter.writeStringField("endTime", this.endTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.endTime));
        jsonWriter.writeIntField("maxConcurrency", this.maxConcurrency);
        return jsonWriter.writeEndObject();
    }

    public static RerunTumblingWindowTriggerActionParameters fromJson(JsonReader jsonReader) throws IOException {
        return (RerunTumblingWindowTriggerActionParameters)jsonReader.readObject(reader -> {
            RerunTumblingWindowTriggerActionParameters deserializedRerunTumblingWindowTriggerActionParameters = new RerunTumblingWindowTriggerActionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("startTime".equals(fieldName)) {
                    deserializedRerunTumblingWindowTriggerActionParameters.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedRerunTumblingWindowTriggerActionParameters.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("maxConcurrency".equals(fieldName)) {
                    deserializedRerunTumblingWindowTriggerActionParameters.maxConcurrency = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRerunTumblingWindowTriggerActionParameters;
        });
    }
}

