/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.DayOfWeek;
import com.azure.analytics.synapse.artifacts.models.RecurrenceScheduleOccurrence;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class RecurrenceSchedule
implements JsonSerializable<RecurrenceSchedule> {
    private List<Integer> minutes;
    private List<Integer> hours;
    private List<DayOfWeek> weekDays;
    private List<Integer> monthDays;
    private List<RecurrenceScheduleOccurrence> monthlyOccurrences;
    private Map<String, Object> additionalProperties;

    public List<Integer> getMinutes() {
        return this.minutes;
    }

    public RecurrenceSchedule setMinutes(List<Integer> minutes) {
        this.minutes = minutes;
        return this;
    }

    public List<Integer> getHours() {
        return this.hours;
    }

    public RecurrenceSchedule setHours(List<Integer> hours) {
        this.hours = hours;
        return this;
    }

    public List<DayOfWeek> getWeekDays() {
        return this.weekDays;
    }

    public RecurrenceSchedule setWeekDays(List<DayOfWeek> weekDays) {
        this.weekDays = weekDays;
        return this;
    }

    public List<Integer> getMonthDays() {
        return this.monthDays;
    }

    public RecurrenceSchedule setMonthDays(List<Integer> monthDays) {
        this.monthDays = monthDays;
        return this;
    }

    public List<RecurrenceScheduleOccurrence> getMonthlyOccurrences() {
        return this.monthlyOccurrences;
    }

    public RecurrenceSchedule setMonthlyOccurrences(List<RecurrenceScheduleOccurrence> monthlyOccurrences) {
        this.monthlyOccurrences = monthlyOccurrences;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public RecurrenceSchedule setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("minutes", this.minutes, (writer, element) -> writer.writeInt(element.intValue()));
        jsonWriter.writeArrayField("hours", this.hours, (writer, element) -> writer.writeInt(element.intValue()));
        jsonWriter.writeArrayField("weekDays", this.weekDays, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("monthDays", this.monthDays, (writer, element) -> writer.writeInt(element.intValue()));
        jsonWriter.writeArrayField("monthlyOccurrences", this.monthlyOccurrences, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static RecurrenceSchedule fromJson(JsonReader jsonReader) throws IOException {
        return (RecurrenceSchedule)jsonReader.readObject(reader -> {
            RecurrenceSchedule deserializedRecurrenceSchedule = new RecurrenceSchedule();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("minutes".equals(fieldName)) {
                    List minutes;
                    deserializedRecurrenceSchedule.minutes = minutes = reader.readArray(reader1 -> reader1.getInt());
                    continue;
                }
                if ("hours".equals(fieldName)) {
                    List hours;
                    deserializedRecurrenceSchedule.hours = hours = reader.readArray(reader1 -> reader1.getInt());
                    continue;
                }
                if ("weekDays".equals(fieldName)) {
                    List weekDays;
                    deserializedRecurrenceSchedule.weekDays = weekDays = reader.readArray(reader1 -> DayOfWeek.fromString(reader1.getString()));
                    continue;
                }
                if ("monthDays".equals(fieldName)) {
                    List monthDays;
                    deserializedRecurrenceSchedule.monthDays = monthDays = reader.readArray(reader1 -> reader1.getInt());
                    continue;
                }
                if ("monthlyOccurrences".equals(fieldName)) {
                    List monthlyOccurrences;
                    deserializedRecurrenceSchedule.monthlyOccurrences = monthlyOccurrences = reader.readArray(reader1 -> RecurrenceScheduleOccurrence.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedRecurrenceSchedule.additionalProperties = additionalProperties;
            return deserializedRecurrenceSchedule;
        });
    }
}

