/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QuickbaseLinkedService
extends LinkedService {
    private String type = "Quickbase";
    private Object url;
    private SecretBase userToken;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getUrl() {
        return this.url;
    }

    public QuickbaseLinkedService setUrl(Object url) {
        this.url = url;
        return this;
    }

    public SecretBase getUserToken() {
        return this.userToken;
    }

    public QuickbaseLinkedService setUserToken(SecretBase userToken) {
        this.userToken = userToken;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public QuickbaseLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public QuickbaseLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public QuickbaseLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public QuickbaseLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public QuickbaseLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public QuickbaseLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.url != null || this.userToken != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("url", this.url);
            jsonWriter.writeJsonField("userToken", (JsonSerializable)this.userToken);
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static QuickbaseLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (QuickbaseLinkedService)jsonReader.readObject(reader -> {
            QuickbaseLinkedService deserializedQuickbaseLinkedService = new QuickbaseLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedQuickbaseLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedQuickbaseLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedQuickbaseLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedQuickbaseLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedQuickbaseLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedQuickbaseLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("url".equals(fieldName)) {
                            deserializedQuickbaseLinkedService.url = reader.readUntyped();
                            continue;
                        }
                        if ("userToken".equals(fieldName)) {
                            deserializedQuickbaseLinkedService.userToken = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedQuickbaseLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedQuickbaseLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedQuickbaseLinkedService;
        });
    }
}

