/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QuickBooksLinkedService
extends LinkedService {
    private String type = "QuickBooks";
    private Object connectionProperties;
    private Object endpoint;
    private Object companyId;
    private Object consumerKey;
    private SecretBase consumerSecret;
    private SecretBase accessToken;
    private SecretBase accessTokenSecret;
    private SecretBase refreshToken;
    private Object useEncryptedEndpoints;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getConnectionProperties() {
        return this.connectionProperties;
    }

    public QuickBooksLinkedService setConnectionProperties(Object connectionProperties) {
        this.connectionProperties = connectionProperties;
        return this;
    }

    public Object getEndpoint() {
        return this.endpoint;
    }

    public QuickBooksLinkedService setEndpoint(Object endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Object getCompanyId() {
        return this.companyId;
    }

    public QuickBooksLinkedService setCompanyId(Object companyId) {
        this.companyId = companyId;
        return this;
    }

    public Object getConsumerKey() {
        return this.consumerKey;
    }

    public QuickBooksLinkedService setConsumerKey(Object consumerKey) {
        this.consumerKey = consumerKey;
        return this;
    }

    public SecretBase getConsumerSecret() {
        return this.consumerSecret;
    }

    public QuickBooksLinkedService setConsumerSecret(SecretBase consumerSecret) {
        this.consumerSecret = consumerSecret;
        return this;
    }

    public SecretBase getAccessToken() {
        return this.accessToken;
    }

    public QuickBooksLinkedService setAccessToken(SecretBase accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public SecretBase getAccessTokenSecret() {
        return this.accessTokenSecret;
    }

    public QuickBooksLinkedService setAccessTokenSecret(SecretBase accessTokenSecret) {
        this.accessTokenSecret = accessTokenSecret;
        return this;
    }

    public SecretBase getRefreshToken() {
        return this.refreshToken;
    }

    public QuickBooksLinkedService setRefreshToken(SecretBase refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    public Object getUseEncryptedEndpoints() {
        return this.useEncryptedEndpoints;
    }

    public QuickBooksLinkedService setUseEncryptedEndpoints(Object useEncryptedEndpoints) {
        this.useEncryptedEndpoints = useEncryptedEndpoints;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public QuickBooksLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public QuickBooksLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public QuickBooksLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public QuickBooksLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public QuickBooksLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public QuickBooksLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.connectionProperties != null || this.endpoint != null || this.companyId != null || this.consumerKey != null || this.consumerSecret != null || this.accessToken != null || this.accessTokenSecret != null || this.refreshToken != null || this.useEncryptedEndpoints != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.connectionProperties != null) {
                jsonWriter.writeUntypedField("connectionProperties", this.connectionProperties);
            }
            jsonWriter.writeUntypedField("endpoint", this.endpoint);
            jsonWriter.writeUntypedField("companyId", this.companyId);
            jsonWriter.writeUntypedField("consumerKey", this.consumerKey);
            jsonWriter.writeJsonField("consumerSecret", (JsonSerializable)this.consumerSecret);
            jsonWriter.writeJsonField("accessToken", (JsonSerializable)this.accessToken);
            jsonWriter.writeJsonField("accessTokenSecret", (JsonSerializable)this.accessTokenSecret);
            jsonWriter.writeJsonField("refreshToken", (JsonSerializable)this.refreshToken);
            if (this.useEncryptedEndpoints != null) {
                jsonWriter.writeUntypedField("useEncryptedEndpoints", this.useEncryptedEndpoints);
            }
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static QuickBooksLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (QuickBooksLinkedService)jsonReader.readObject(reader -> {
            QuickBooksLinkedService deserializedQuickBooksLinkedService = new QuickBooksLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedQuickBooksLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedQuickBooksLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedQuickBooksLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedQuickBooksLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedQuickBooksLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedQuickBooksLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("connectionProperties".equals(fieldName)) {
                            deserializedQuickBooksLinkedService.connectionProperties = reader.readUntyped();
                            continue;
                        }
                        if ("endpoint".equals(fieldName)) {
                            deserializedQuickBooksLinkedService.endpoint = reader.readUntyped();
                            continue;
                        }
                        if ("companyId".equals(fieldName)) {
                            deserializedQuickBooksLinkedService.companyId = reader.readUntyped();
                            continue;
                        }
                        if ("consumerKey".equals(fieldName)) {
                            deserializedQuickBooksLinkedService.consumerKey = reader.readUntyped();
                            continue;
                        }
                        if ("consumerSecret".equals(fieldName)) {
                            deserializedQuickBooksLinkedService.consumerSecret = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("accessToken".equals(fieldName)) {
                            deserializedQuickBooksLinkedService.accessToken = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("accessTokenSecret".equals(fieldName)) {
                            deserializedQuickBooksLinkedService.accessTokenSecret = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("refreshToken".equals(fieldName)) {
                            deserializedQuickBooksLinkedService.refreshToken = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("useEncryptedEndpoints".equals(fieldName)) {
                            deserializedQuickBooksLinkedService.useEncryptedEndpoints = reader.readUntyped();
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedQuickBooksLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedQuickBooksLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedQuickBooksLinkedService;
        });
    }
}

