/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.PipelineRunInvokedBy;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

public final class PipelineRun
implements JsonSerializable<PipelineRun> {
    private String runId;
    private String runGroupId;
    private Boolean isLatest;
    private String pipelineName;
    private Map<String, String> parameters;
    private PipelineRunInvokedBy invokedBy;
    private OffsetDateTime lastUpdated;
    private OffsetDateTime runStart;
    private OffsetDateTime runEnd;
    private Integer durationInMs;
    private String status;
    private String message;
    private Map<String, Object> additionalProperties;

    public String getRunId() {
        return this.runId;
    }

    public String getRunGroupId() {
        return this.runGroupId;
    }

    public Boolean isLatest() {
        return this.isLatest;
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public PipelineRunInvokedBy getInvokedBy() {
        return this.invokedBy;
    }

    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public OffsetDateTime getRunStart() {
        return this.runStart;
    }

    public OffsetDateTime getRunEnd() {
        return this.runEnd;
    }

    public Integer getDurationInMs() {
        return this.durationInMs;
    }

    public String getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public PipelineRun setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static PipelineRun fromJson(JsonReader jsonReader) throws IOException {
        return (PipelineRun)jsonReader.readObject(reader -> {
            PipelineRun deserializedPipelineRun = new PipelineRun();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("runId".equals(fieldName)) {
                    deserializedPipelineRun.runId = reader.getString();
                    continue;
                }
                if ("runGroupId".equals(fieldName)) {
                    deserializedPipelineRun.runGroupId = reader.getString();
                    continue;
                }
                if ("isLatest".equals(fieldName)) {
                    deserializedPipelineRun.isLatest = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("pipelineName".equals(fieldName)) {
                    deserializedPipelineRun.pipelineName = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedPipelineRun.parameters = parameters = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("invokedBy".equals(fieldName)) {
                    deserializedPipelineRun.invokedBy = PipelineRunInvokedBy.fromJson(reader);
                    continue;
                }
                if ("lastUpdated".equals(fieldName)) {
                    deserializedPipelineRun.lastUpdated = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("runStart".equals(fieldName)) {
                    deserializedPipelineRun.runStart = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("runEnd".equals(fieldName)) {
                    deserializedPipelineRun.runEnd = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("durationInMs".equals(fieldName)) {
                    deserializedPipelineRun.durationInMs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedPipelineRun.status = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedPipelineRun.message = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedPipelineRun.additionalProperties = additionalProperties;
            return deserializedPipelineRun;
        });
    }
}

