/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CopySource;
import com.azure.analytics.synapse.artifacts.models.OraclePartitionOption;
import com.azure.analytics.synapse.artifacts.models.OraclePartitionSettings;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class OracleSource
extends CopySource {
    private String type = "OracleSource";
    private Object oracleReaderQuery;
    private Object queryTimeout;
    private OraclePartitionOption partitionOption;
    private OraclePartitionSettings partitionSettings;
    private Object additionalColumns;
    private Object numberPrecision;
    private Object numberScale;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getOracleReaderQuery() {
        return this.oracleReaderQuery;
    }

    public OracleSource setOracleReaderQuery(Object oracleReaderQuery) {
        this.oracleReaderQuery = oracleReaderQuery;
        return this;
    }

    public Object getQueryTimeout() {
        return this.queryTimeout;
    }

    public OracleSource setQueryTimeout(Object queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    public OraclePartitionOption getPartitionOption() {
        return this.partitionOption;
    }

    public OracleSource setPartitionOption(OraclePartitionOption partitionOption) {
        this.partitionOption = partitionOption;
        return this;
    }

    public OraclePartitionSettings getPartitionSettings() {
        return this.partitionSettings;
    }

    public OracleSource setPartitionSettings(OraclePartitionSettings partitionSettings) {
        this.partitionSettings = partitionSettings;
        return this;
    }

    public Object getAdditionalColumns() {
        return this.additionalColumns;
    }

    public OracleSource setAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    public Object getNumberPrecision() {
        return this.numberPrecision;
    }

    public OracleSource setNumberPrecision(Object numberPrecision) {
        this.numberPrecision = numberPrecision;
        return this;
    }

    public Object getNumberScale() {
        return this.numberScale;
    }

    public OracleSource setNumberScale(Object numberScale) {
        this.numberScale = numberScale;
        return this;
    }

    @Override
    public OracleSource setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public OracleSource setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public OracleSource setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.oracleReaderQuery != null) {
            jsonWriter.writeUntypedField("oracleReaderQuery", this.oracleReaderQuery);
        }
        if (this.queryTimeout != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.queryTimeout);
        }
        jsonWriter.writeStringField("partitionOption", this.partitionOption == null ? null : this.partitionOption.toString());
        jsonWriter.writeJsonField("partitionSettings", (JsonSerializable)this.partitionSettings);
        if (this.additionalColumns != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        }
        if (this.numberPrecision != null) {
            jsonWriter.writeUntypedField("numberPrecision", this.numberPrecision);
        }
        if (this.numberScale != null) {
            jsonWriter.writeUntypedField("numberScale", this.numberScale);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static OracleSource fromJson(JsonReader jsonReader) throws IOException {
        return (OracleSource)jsonReader.readObject(reader -> {
            OracleSource deserializedOracleSource = new OracleSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedOracleSource.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedOracleSource.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedOracleSource.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedOracleSource.type = reader.getString();
                    continue;
                }
                if ("oracleReaderQuery".equals(fieldName)) {
                    deserializedOracleSource.oracleReaderQuery = reader.readUntyped();
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedOracleSource.queryTimeout = reader.readUntyped();
                    continue;
                }
                if ("partitionOption".equals(fieldName)) {
                    deserializedOracleSource.partitionOption = OraclePartitionOption.fromString(reader.getString());
                    continue;
                }
                if ("partitionSettings".equals(fieldName)) {
                    deserializedOracleSource.partitionSettings = OraclePartitionSettings.fromJson(reader);
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedOracleSource.additionalColumns = reader.readUntyped();
                    continue;
                }
                if ("numberPrecision".equals(fieldName)) {
                    deserializedOracleSource.numberPrecision = reader.readUntyped();
                    continue;
                }
                if ("numberScale".equals(fieldName)) {
                    deserializedOracleSource.numberScale = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedOracleSource.setAdditionalProperties(additionalProperties);
            return deserializedOracleSource;
        });
    }
}

