/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CopySource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Office365Source
extends CopySource {
    private String type = "Office365Source";
    private Object allowedGroups;
    private Object userScopeFilterUri;
    private Object dateFilterColumn;
    private Object startTime;
    private Object endTime;
    private Object outputColumns;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getAllowedGroups() {
        return this.allowedGroups;
    }

    public Office365Source setAllowedGroups(Object allowedGroups) {
        this.allowedGroups = allowedGroups;
        return this;
    }

    public Object getUserScopeFilterUri() {
        return this.userScopeFilterUri;
    }

    public Office365Source setUserScopeFilterUri(Object userScopeFilterUri) {
        this.userScopeFilterUri = userScopeFilterUri;
        return this;
    }

    public Object getDateFilterColumn() {
        return this.dateFilterColumn;
    }

    public Office365Source setDateFilterColumn(Object dateFilterColumn) {
        this.dateFilterColumn = dateFilterColumn;
        return this;
    }

    public Object getStartTime() {
        return this.startTime;
    }

    public Office365Source setStartTime(Object startTime) {
        this.startTime = startTime;
        return this;
    }

    public Object getEndTime() {
        return this.endTime;
    }

    public Office365Source setEndTime(Object endTime) {
        this.endTime = endTime;
        return this;
    }

    public Object getOutputColumns() {
        return this.outputColumns;
    }

    public Office365Source setOutputColumns(Object outputColumns) {
        this.outputColumns = outputColumns;
        return this;
    }

    @Override
    public Office365Source setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public Office365Source setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public Office365Source setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.allowedGroups != null) {
            jsonWriter.writeUntypedField("allowedGroups", this.allowedGroups);
        }
        if (this.userScopeFilterUri != null) {
            jsonWriter.writeUntypedField("userScopeFilterUri", this.userScopeFilterUri);
        }
        if (this.dateFilterColumn != null) {
            jsonWriter.writeUntypedField("dateFilterColumn", this.dateFilterColumn);
        }
        if (this.startTime != null) {
            jsonWriter.writeUntypedField("startTime", this.startTime);
        }
        if (this.endTime != null) {
            jsonWriter.writeUntypedField("endTime", this.endTime);
        }
        if (this.outputColumns != null) {
            jsonWriter.writeUntypedField("outputColumns", this.outputColumns);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static Office365Source fromJson(JsonReader jsonReader) throws IOException {
        return (Office365Source)jsonReader.readObject(reader -> {
            Office365Source deserializedOffice365Source = new Office365Source();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedOffice365Source.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedOffice365Source.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedOffice365Source.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedOffice365Source.type = reader.getString();
                    continue;
                }
                if ("allowedGroups".equals(fieldName)) {
                    deserializedOffice365Source.allowedGroups = reader.readUntyped();
                    continue;
                }
                if ("userScopeFilterUri".equals(fieldName)) {
                    deserializedOffice365Source.userScopeFilterUri = reader.readUntyped();
                    continue;
                }
                if ("dateFilterColumn".equals(fieldName)) {
                    deserializedOffice365Source.dateFilterColumn = reader.readUntyped();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedOffice365Source.startTime = reader.readUntyped();
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedOffice365Source.endTime = reader.readUntyped();
                    continue;
                }
                if ("outputColumns".equals(fieldName)) {
                    deserializedOffice365Source.outputColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedOffice365Source.setAdditionalProperties(additionalProperties);
            return deserializedOffice365Source;
        });
    }
}

