/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.analytics.synapse.artifacts.models.SecretBase;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Office365LinkedService
extends LinkedService {
    private String type = "Office365";
    private Object office365TenantId;
    private Object servicePrincipalTenantId;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object servicePrincipalCredentialType;
    private SecretBase servicePrincipalEmbeddedCert;
    private SecretBase servicePrincipalEmbeddedCertPassword;
    private Object encryptedCredential;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getOffice365TenantId() {
        return this.office365TenantId;
    }

    public Office365LinkedService setOffice365TenantId(Object office365TenantId) {
        this.office365TenantId = office365TenantId;
        return this;
    }

    public Object getServicePrincipalTenantId() {
        return this.servicePrincipalTenantId;
    }

    public Office365LinkedService setServicePrincipalTenantId(Object servicePrincipalTenantId) {
        this.servicePrincipalTenantId = servicePrincipalTenantId;
        return this;
    }

    public Object getServicePrincipalId() {
        return this.servicePrincipalId;
    }

    public Office365LinkedService setServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase getServicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public Office365LinkedService setServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object getServicePrincipalCredentialType() {
        return this.servicePrincipalCredentialType;
    }

    public Office365LinkedService setServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        this.servicePrincipalCredentialType = servicePrincipalCredentialType;
        return this;
    }

    public SecretBase getServicePrincipalEmbeddedCert() {
        return this.servicePrincipalEmbeddedCert;
    }

    public Office365LinkedService setServicePrincipalEmbeddedCert(SecretBase servicePrincipalEmbeddedCert) {
        this.servicePrincipalEmbeddedCert = servicePrincipalEmbeddedCert;
        return this;
    }

    public SecretBase getServicePrincipalEmbeddedCertPassword() {
        return this.servicePrincipalEmbeddedCertPassword;
    }

    public Office365LinkedService setServicePrincipalEmbeddedCertPassword(SecretBase servicePrincipalEmbeddedCertPassword) {
        this.servicePrincipalEmbeddedCertPassword = servicePrincipalEmbeddedCertPassword;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public Office365LinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    @Override
    public Office365LinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public Office365LinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public Office365LinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public Office365LinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public Office365LinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.office365TenantId != null || this.servicePrincipalTenantId != null || this.servicePrincipalId != null || this.servicePrincipalKey != null || this.servicePrincipalCredentialType != null || this.servicePrincipalEmbeddedCert != null || this.servicePrincipalEmbeddedCertPassword != null || this.encryptedCredential != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("office365TenantId", this.office365TenantId);
            jsonWriter.writeUntypedField("servicePrincipalTenantId", this.servicePrincipalTenantId);
            jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
            jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
            if (this.servicePrincipalCredentialType != null) {
                jsonWriter.writeUntypedField("servicePrincipalCredentialType", this.servicePrincipalCredentialType);
            }
            jsonWriter.writeJsonField("servicePrincipalEmbeddedCert", (JsonSerializable)this.servicePrincipalEmbeddedCert);
            jsonWriter.writeJsonField("servicePrincipalEmbeddedCertPassword", (JsonSerializable)this.servicePrincipalEmbeddedCertPassword);
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static Office365LinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (Office365LinkedService)jsonReader.readObject(reader -> {
            Office365LinkedService deserializedOffice365LinkedService = new Office365LinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedOffice365LinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedOffice365LinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedOffice365LinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedOffice365LinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedOffice365LinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedOffice365LinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("office365TenantId".equals(fieldName)) {
                            deserializedOffice365LinkedService.office365TenantId = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalTenantId".equals(fieldName)) {
                            deserializedOffice365LinkedService.servicePrincipalTenantId = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalId".equals(fieldName)) {
                            deserializedOffice365LinkedService.servicePrincipalId = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalKey".equals(fieldName)) {
                            deserializedOffice365LinkedService.servicePrincipalKey = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("servicePrincipalCredentialType".equals(fieldName)) {
                            deserializedOffice365LinkedService.servicePrincipalCredentialType = reader.readUntyped();
                            continue;
                        }
                        if ("servicePrincipalEmbeddedCert".equals(fieldName)) {
                            deserializedOffice365LinkedService.servicePrincipalEmbeddedCert = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("servicePrincipalEmbeddedCertPassword".equals(fieldName)) {
                            deserializedOffice365LinkedService.servicePrincipalEmbeddedCertPassword = SecretBase.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedOffice365LinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedOffice365LinkedService.setAdditionalProperties(additionalProperties);
            return deserializedOffice365LinkedService;
        });
    }
}

