/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.AzureKeyVaultSecretReference;
import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MySqlLinkedService
extends LinkedService {
    private String type = "MySql";
    private Object driverVersion;
    private Object connectionString;
    private Object server;
    private Object port;
    private Object username;
    private Object database;
    private Object sslMode;
    private Object useSystemTrustStore;
    private AzureKeyVaultSecretReference password;
    private Object encryptedCredential;
    private Object allowZeroDateTime;
    private Object connectionTimeout;
    private Object convertZeroDateTime;
    private Object guidFormat;
    private Object sslCert;
    private Object sslKey;
    private Object treatTinyAsBoolean;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getDriverVersion() {
        return this.driverVersion;
    }

    public MySqlLinkedService setDriverVersion(Object driverVersion) {
        this.driverVersion = driverVersion;
        return this;
    }

    public Object getConnectionString() {
        return this.connectionString;
    }

    public MySqlLinkedService setConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public Object getServer() {
        return this.server;
    }

    public MySqlLinkedService setServer(Object server) {
        this.server = server;
        return this;
    }

    public Object getPort() {
        return this.port;
    }

    public MySqlLinkedService setPort(Object port) {
        this.port = port;
        return this;
    }

    public Object getUsername() {
        return this.username;
    }

    public MySqlLinkedService setUsername(Object username) {
        this.username = username;
        return this;
    }

    public Object getDatabase() {
        return this.database;
    }

    public MySqlLinkedService setDatabase(Object database) {
        this.database = database;
        return this;
    }

    public Object getSslMode() {
        return this.sslMode;
    }

    public MySqlLinkedService setSslMode(Object sslMode) {
        this.sslMode = sslMode;
        return this;
    }

    public Object getUseSystemTrustStore() {
        return this.useSystemTrustStore;
    }

    public MySqlLinkedService setUseSystemTrustStore(Object useSystemTrustStore) {
        this.useSystemTrustStore = useSystemTrustStore;
        return this;
    }

    public AzureKeyVaultSecretReference getPassword() {
        return this.password;
    }

    public MySqlLinkedService setPassword(AzureKeyVaultSecretReference password) {
        this.password = password;
        return this;
    }

    public Object getEncryptedCredential() {
        return this.encryptedCredential;
    }

    public MySqlLinkedService setEncryptedCredential(Object encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public Object getAllowZeroDateTime() {
        return this.allowZeroDateTime;
    }

    public MySqlLinkedService setAllowZeroDateTime(Object allowZeroDateTime) {
        this.allowZeroDateTime = allowZeroDateTime;
        return this;
    }

    public Object getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public MySqlLinkedService setConnectionTimeout(Object connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public Object getConvertZeroDateTime() {
        return this.convertZeroDateTime;
    }

    public MySqlLinkedService setConvertZeroDateTime(Object convertZeroDateTime) {
        this.convertZeroDateTime = convertZeroDateTime;
        return this;
    }

    public Object getGuidFormat() {
        return this.guidFormat;
    }

    public MySqlLinkedService setGuidFormat(Object guidFormat) {
        this.guidFormat = guidFormat;
        return this;
    }

    public Object getSslCert() {
        return this.sslCert;
    }

    public MySqlLinkedService setSslCert(Object sslCert) {
        this.sslCert = sslCert;
        return this;
    }

    public Object getSslKey() {
        return this.sslKey;
    }

    public MySqlLinkedService setSslKey(Object sslKey) {
        this.sslKey = sslKey;
        return this;
    }

    public Object getTreatTinyAsBoolean() {
        return this.treatTinyAsBoolean;
    }

    public MySqlLinkedService setTreatTinyAsBoolean(Object treatTinyAsBoolean) {
        this.treatTinyAsBoolean = treatTinyAsBoolean;
        return this;
    }

    @Override
    public MySqlLinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public MySqlLinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public MySqlLinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public MySqlLinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public MySqlLinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.driverVersion != null || this.connectionString != null || this.server != null || this.port != null || this.username != null || this.database != null || this.sslMode != null || this.useSystemTrustStore != null || this.password != null || this.encryptedCredential != null || this.allowZeroDateTime != null || this.connectionTimeout != null || this.convertZeroDateTime != null || this.guidFormat != null || this.sslCert != null || this.sslKey != null || this.treatTinyAsBoolean != null) {
            jsonWriter.writeStartObject("typeProperties");
            if (this.driverVersion != null) {
                jsonWriter.writeUntypedField("driverVersion", this.driverVersion);
            }
            if (this.connectionString != null) {
                jsonWriter.writeUntypedField("connectionString", this.connectionString);
            }
            if (this.server != null) {
                jsonWriter.writeUntypedField("server", this.server);
            }
            if (this.port != null) {
                jsonWriter.writeUntypedField("port", this.port);
            }
            if (this.username != null) {
                jsonWriter.writeUntypedField("username", this.username);
            }
            if (this.database != null) {
                jsonWriter.writeUntypedField("database", this.database);
            }
            if (this.sslMode != null) {
                jsonWriter.writeUntypedField("sslMode", this.sslMode);
            }
            if (this.useSystemTrustStore != null) {
                jsonWriter.writeUntypedField("useSystemTrustStore", this.useSystemTrustStore);
            }
            jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
            if (this.encryptedCredential != null) {
                jsonWriter.writeUntypedField("encryptedCredential", this.encryptedCredential);
            }
            if (this.allowZeroDateTime != null) {
                jsonWriter.writeUntypedField("allowZeroDateTime", this.allowZeroDateTime);
            }
            if (this.connectionTimeout != null) {
                jsonWriter.writeUntypedField("connectionTimeout", this.connectionTimeout);
            }
            if (this.convertZeroDateTime != null) {
                jsonWriter.writeUntypedField("convertZeroDateTime", this.convertZeroDateTime);
            }
            if (this.guidFormat != null) {
                jsonWriter.writeUntypedField("guidFormat", this.guidFormat);
            }
            if (this.sslCert != null) {
                jsonWriter.writeUntypedField("sslCert", this.sslCert);
            }
            if (this.sslKey != null) {
                jsonWriter.writeUntypedField("sslKey", this.sslKey);
            }
            if (this.treatTinyAsBoolean != null) {
                jsonWriter.writeUntypedField("treatTinyAsBoolean", this.treatTinyAsBoolean);
            }
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MySqlLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (MySqlLinkedService)jsonReader.readObject(reader -> {
            MySqlLinkedService deserializedMySqlLinkedService = new MySqlLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedMySqlLinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedMySqlLinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMySqlLinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedMySqlLinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedMySqlLinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMySqlLinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("driverVersion".equals(fieldName)) {
                            deserializedMySqlLinkedService.driverVersion = reader.readUntyped();
                            continue;
                        }
                        if ("connectionString".equals(fieldName)) {
                            deserializedMySqlLinkedService.connectionString = reader.readUntyped();
                            continue;
                        }
                        if ("server".equals(fieldName)) {
                            deserializedMySqlLinkedService.server = reader.readUntyped();
                            continue;
                        }
                        if ("port".equals(fieldName)) {
                            deserializedMySqlLinkedService.port = reader.readUntyped();
                            continue;
                        }
                        if ("username".equals(fieldName)) {
                            deserializedMySqlLinkedService.username = reader.readUntyped();
                            continue;
                        }
                        if ("database".equals(fieldName)) {
                            deserializedMySqlLinkedService.database = reader.readUntyped();
                            continue;
                        }
                        if ("sslMode".equals(fieldName)) {
                            deserializedMySqlLinkedService.sslMode = reader.readUntyped();
                            continue;
                        }
                        if ("useSystemTrustStore".equals(fieldName)) {
                            deserializedMySqlLinkedService.useSystemTrustStore = reader.readUntyped();
                            continue;
                        }
                        if ("password".equals(fieldName)) {
                            deserializedMySqlLinkedService.password = AzureKeyVaultSecretReference.fromJson(reader);
                            continue;
                        }
                        if ("encryptedCredential".equals(fieldName)) {
                            deserializedMySqlLinkedService.encryptedCredential = reader.readUntyped();
                            continue;
                        }
                        if ("allowZeroDateTime".equals(fieldName)) {
                            deserializedMySqlLinkedService.allowZeroDateTime = reader.readUntyped();
                            continue;
                        }
                        if ("connectionTimeout".equals(fieldName)) {
                            deserializedMySqlLinkedService.connectionTimeout = reader.readUntyped();
                            continue;
                        }
                        if ("convertZeroDateTime".equals(fieldName)) {
                            deserializedMySqlLinkedService.convertZeroDateTime = reader.readUntyped();
                            continue;
                        }
                        if ("guidFormat".equals(fieldName)) {
                            deserializedMySqlLinkedService.guidFormat = reader.readUntyped();
                            continue;
                        }
                        if ("sslCert".equals(fieldName)) {
                            deserializedMySqlLinkedService.sslCert = reader.readUntyped();
                            continue;
                        }
                        if ("sslKey".equals(fieldName)) {
                            deserializedMySqlLinkedService.sslKey = reader.readUntyped();
                            continue;
                        }
                        if ("treatTinyAsBoolean".equals(fieldName)) {
                            deserializedMySqlLinkedService.treatTinyAsBoolean = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMySqlLinkedService.setAdditionalProperties(additionalProperties);
            return deserializedMySqlLinkedService;
        });
    }
}

