/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.CopySource;
import com.azure.analytics.synapse.artifacts.models.MongoDbCursorMethodsProperties;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MongoDbV2Source
extends CopySource {
    private String type = "MongoDbV2Source";
    private Object filter;
    private MongoDbCursorMethodsProperties cursorMethods;
    private Object batchSize;
    private Object queryTimeout;
    private Object additionalColumns;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getFilter() {
        return this.filter;
    }

    public MongoDbV2Source setFilter(Object filter) {
        this.filter = filter;
        return this;
    }

    public MongoDbCursorMethodsProperties getCursorMethods() {
        return this.cursorMethods;
    }

    public MongoDbV2Source setCursorMethods(MongoDbCursorMethodsProperties cursorMethods) {
        this.cursorMethods = cursorMethods;
        return this;
    }

    public Object getBatchSize() {
        return this.batchSize;
    }

    public MongoDbV2Source setBatchSize(Object batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Object getQueryTimeout() {
        return this.queryTimeout;
    }

    public MongoDbV2Source setQueryTimeout(Object queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    public Object getAdditionalColumns() {
        return this.additionalColumns;
    }

    public MongoDbV2Source setAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    @Override
    public MongoDbV2Source setSourceRetryCount(Object sourceRetryCount) {
        super.setSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public MongoDbV2Source setSourceRetryWait(Object sourceRetryWait) {
        super.setSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public MongoDbV2Source setMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.setMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.getSourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.getSourceRetryCount());
        }
        if (this.getSourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.getSourceRetryWait());
        }
        if (this.getMaxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.getMaxConcurrentConnections());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.filter != null) {
            jsonWriter.writeUntypedField("filter", this.filter);
        }
        jsonWriter.writeJsonField("cursorMethods", (JsonSerializable)this.cursorMethods);
        if (this.batchSize != null) {
            jsonWriter.writeUntypedField("batchSize", this.batchSize);
        }
        if (this.queryTimeout != null) {
            jsonWriter.writeUntypedField("queryTimeout", this.queryTimeout);
        }
        if (this.additionalColumns != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MongoDbV2Source fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbV2Source)jsonReader.readObject(reader -> {
            MongoDbV2Source deserializedMongoDbV2Source = new MongoDbV2Source();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedMongoDbV2Source.setSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedMongoDbV2Source.setSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedMongoDbV2Source.setMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMongoDbV2Source.type = reader.getString();
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    deserializedMongoDbV2Source.filter = reader.readUntyped();
                    continue;
                }
                if ("cursorMethods".equals(fieldName)) {
                    deserializedMongoDbV2Source.cursorMethods = MongoDbCursorMethodsProperties.fromJson(reader);
                    continue;
                }
                if ("batchSize".equals(fieldName)) {
                    deserializedMongoDbV2Source.batchSize = reader.readUntyped();
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedMongoDbV2Source.queryTimeout = reader.readUntyped();
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedMongoDbV2Source.additionalColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMongoDbV2Source.setAdditionalProperties(additionalProperties);
            return deserializedMongoDbV2Source;
        });
    }
}

