/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.models;

import com.azure.analytics.synapse.artifacts.models.IntegrationRuntimeReference;
import com.azure.analytics.synapse.artifacts.models.LinkedService;
import com.azure.analytics.synapse.artifacts.models.ParameterSpecification;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MongoDbV2LinkedService
extends LinkedService {
    private String type = "MongoDbV2";
    private Object connectionString;
    private Object database;

    @Override
    public String getType() {
        return this.type;
    }

    public Object getConnectionString() {
        return this.connectionString;
    }

    public MongoDbV2LinkedService setConnectionString(Object connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    public Object getDatabase() {
        return this.database;
    }

    public MongoDbV2LinkedService setDatabase(Object database) {
        this.database = database;
        return this;
    }

    @Override
    public MongoDbV2LinkedService setVersion(String version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public MongoDbV2LinkedService setConnectVia(IntegrationRuntimeReference connectVia) {
        super.setConnectVia(connectVia);
        return this;
    }

    @Override
    public MongoDbV2LinkedService setDescription(String description) {
        super.setDescription(description);
        return this;
    }

    @Override
    public MongoDbV2LinkedService setParameters(Map<String, ParameterSpecification> parameters) {
        super.setParameters(parameters);
        return this;
    }

    @Override
    public MongoDbV2LinkedService setAnnotations(List<Object> annotations) {
        super.setAnnotations(annotations);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.getVersion());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.getConnectVia());
        jsonWriter.writeStringField("description", this.getDescription());
        jsonWriter.writeMapField("parameters", this.getParameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.getAnnotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        if (this.connectionString != null || this.database != null) {
            jsonWriter.writeStartObject("typeProperties");
            jsonWriter.writeUntypedField("connectionString", this.connectionString);
            jsonWriter.writeUntypedField("database", this.database);
            jsonWriter.writeEndObject();
        }
        if (this.getAdditionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.getAdditionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MongoDbV2LinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbV2LinkedService)jsonReader.readObject(reader -> {
            MongoDbV2LinkedService deserializedMongoDbV2LinkedService = new MongoDbV2LinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedMongoDbV2LinkedService.setVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedMongoDbV2LinkedService.setConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMongoDbV2LinkedService.setDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedMongoDbV2LinkedService.setParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedMongoDbV2LinkedService.setAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMongoDbV2LinkedService.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName) && reader.currentToken() == JsonToken.START_OBJECT) {
                    while (reader.nextToken() != JsonToken.END_OBJECT) {
                        fieldName = reader.getFieldName();
                        reader.nextToken();
                        if ("connectionString".equals(fieldName)) {
                            deserializedMongoDbV2LinkedService.connectionString = reader.readUntyped();
                            continue;
                        }
                        if ("database".equals(fieldName)) {
                            deserializedMongoDbV2LinkedService.database = reader.readUntyped();
                            continue;
                        }
                        reader.skipChildren();
                    }
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMongoDbV2LinkedService.setAdditionalProperties(additionalProperties);
            return deserializedMongoDbV2LinkedService;
        });
    }
}

